/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.database.generic;

import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import luwa.marlin.database.generic.DatabaseSystem;

public class ConfiguredDatabase {
    private final String url;
    private final String user;
    private final String password;
    private final long readTimeoutMilliseconds;

    public ConfiguredDatabase(String url, String user, String password, long readTimeoutMilliseconds) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.readTimeoutMilliseconds = readTimeoutMilliseconds;
    }

    public String url() {
        return this.url;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public long readTimeoutMilliseconds() {
        return this.readTimeoutMilliseconds;
    }

    public DataSource createAsDataSource() throws SQLException {
        Optional<DatabaseSystem> dbSystem = DatabaseSystem.fromURL(this.url);
        if (dbSystem.isEmpty()) {
            throw new RuntimeException("Nicht unterst\u00fctztes Datenbanksystem f\u00fcr Connection-String: " + this.url);
        }
        return dbSystem.get().createDataSource(this.url, this.user, this.password, this.readTimeoutMilliseconds);
    }

    public boolean isComplete() {
        return !"".equals(this.url) && !"".equals(this.user) && !"".equals(this.password);
    }
}

