/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.configuration.stammdaten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import luwa.marlin.configuration.stammdaten.Stammdaten;

public class AlteStammdaten
implements Stammdaten {
    @Override
    public String dasaView() {
        return "ohyd.v_pegeldaten_dasa";
    }

    @Override
    public String pegeldatenView() {
        return "v_pegeldaten";
    }

    @Override
    public String pegelnullpunktView() {
        return "v_pegeldaten_pnp";
    }

    @Override
    public String abflussnullpunktView() {
        return "v_messtelle_abflussnullpunkt";
    }

    @Override
    public String lageName() {
        return "lage.lage AS lage_gewaesser";
    }

    @Override
    public String landkreisName() {
        return "lkr.landkreis_name AS landkreis";
    }

    @Override
    public Stream<String> deleteStatementsNullpunkte() {
        return Stream.of("delete from ohyd.messtelle_nullpunkt where messtellen_nr=?", "delete from ohyd.messtelle_abflussnullpunkt where messtellen_nr=?", "delete from ohyd.messtelle_abstichnullpunkt where messtellen_nr=?");
    }

    @Override
    public void copyNullpunkte(Connection connection, int target, int source) throws SQLException {
        List<String> statements = Arrays.asList("insert into ohyd.messtelle_nullpunkt (id, messtellen_nr, aenderungsdatum, aenderung_von, anlagedatum, anlage_von, dimension, eingemessen_am, gueltig_von_datum, messtellen_nullpunkt, np_genauigkeit, vermessungssystem) (select ohyd.messtelle_nullpunkt_seq.nextval, ?, aenderungsdatum, aenderung_von, anlagedatum, anlage_von, dimension, eingemessen_am, gueltig_von_datum, messtellen_nullpunkt, np_genauigkeit, vermessungssystem from ohyd.messtelle_nullpunkt where messtellen_nr=?)", "insert into ohyd.messtelle_abflussnullpunkt (id, messtellen_nr, abflussnullpunkt, abflussnull_entspricht_w, aenderungsdatum, aenderung_von, anlagedatum, anlage_von, anp_genauigkeit, dimension, eingemessen_am, gueltig_von_datum, schwellenniveau, vermessungssystem) (select ohyd.messtelle_abflussnullpunkt_seq.nextval, ?, abflussnullpunkt, abflussnull_entspricht_w, aenderungsdatum, aenderung_von, anlagedatum, anlage_von, anp_genauigkeit, dimension, eingemessen_am, gueltig_von_datum, schwellenniveau, vermessungssystem from ohyd.messtelle_abflussnullpunkt where messtellen_nr=?)", "insert into ohyd.messtelle_abstichnullpunkt (id, messtellen_nr, abstich_nullpunkt, abstich_ort, aenderungsdatum, aenderung_von, anlagedatum, anlage_von, dimension, eingemessen_am, gueltig_von_datum, np_genauigkeit, vermessungssystem) (select ohyd.messtelle_abstichnullpunkt_seq.nextval, ?, abstich_nullpunkt, abstich_ort, aenderungsdatum, aenderung_von, anlagedatum, anlage_von, dimension, eingemessen_am, gueltig_von_datum, np_genauigkeit, vermessungssystem from ohyd.messtelle_abstichnullpunkt where messtellen_nr=?)");
        for (String statement : statements) {
            System.out.println("Executing " + statement);
            PreparedStatement insertValue = connection.prepareStatement(statement);
            try {
                insertValue.setInt(1, target);
                insertValue.setInt(2, source);
                insertValue.execute();
            }
            finally {
                if (insertValue == null) continue;
                insertValue.close();
            }
        }
    }

    @Override
    public String joinLandkreis() {
        return "LEFT OUTER JOIN sl_landkreis lkr ON p.landkreis_nr=lkr.landkreis_nr ";
    }

    @Override
    public String joinLage() {
        return "LEFT OUTER JOIN sl_lage lage ON p.lage_nr=lage.lage_nr ";
    }
}

