/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import java.util.BitSet;

public final class Rfc6265CookieSupport {
    private static final BitSet domainValid;

    public static void validateCookieValue(String value) {
        int start = 0;
        int end = value.length();
        if (end > 1 && value.charAt(0) == '\"' && value.charAt(end - 1) == '\"') {
            start = 1;
            --end;
        }
        char[] chars = value.toCharArray();
        for (int i2 = start; i2 < end; ++i2) {
            char c2 = chars[i2];
            if (c2 >= '!' && c2 != '\"' && c2 != ',' && c2 != ';' && c2 != '\\' && c2 != '\u007f') continue;
            throw UndertowMessages.MESSAGES.invalidCookieValue(Integer.toString(c2));
        }
    }

    public static void validateDomain(String domain) {
        int prev = -1;
        int cur = -1;
        char[] chars = domain.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            prev = cur;
            cur = chars[i2];
            if (!domainValid.get(cur)) {
                throw UndertowMessages.MESSAGES.invalidCookieDomain(domain);
            }
            if (!(prev != 46 && prev != -1 || cur != 46 && cur != 45)) {
                throw UndertowMessages.MESSAGES.invalidCookieDomain(domain);
            }
            if (prev != 45 || cur != 46) continue;
            throw UndertowMessages.MESSAGES.invalidCookieDomain(domain);
        }
        if (cur == 46 || cur == 45) {
            throw UndertowMessages.MESSAGES.invalidCookieDomain(domain);
        }
    }

    public static void validatePath(String path) {
        char[] chars = path.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char ch = chars[i2];
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw UndertowMessages.MESSAGES.invalidCookiePath(path);
        }
    }

    static {
        int c2;
        domainValid = new BitSet(128);
        for (c2 = 48; c2 <= 57; c2 = (int)((char)(c2 + 1))) {
            domainValid.set(c2);
        }
        for (c2 = 97; c2 <= 122; c2 = (int)((char)(c2 + 1))) {
            domainValid.set(c2);
        }
        for (c2 = 65; c2 <= 90; c2 = (int)((char)(c2 + 1))) {
            domainValid.set(c2);
        }
        domainValid.set(46);
        domainValid.set(45);
    }
}

