/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SslSessionConfig
implements SessionConfig {
    private final SessionConfig fallbackSessionConfig;
    private final Map<Key, String> sessions = new HashMap<Key, String>();
    private final Map<String, Key> reverse = new HashMap<String, Key>();

    public SslSessionConfig(SessionConfig fallbackSessionConfig, SessionManager sessionManager) {
        this.fallbackSessionConfig = fallbackSessionConfig;
        sessionManager.registerSessionListener(new SessionListener(){

            @Override
            public void sessionCreated(Session session, HttpServerExchange exchange) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
                SslSessionConfig sslSessionConfig = SslSessionConfig.this;
                synchronized (sslSessionConfig) {
                    Key sid = (Key)SslSessionConfig.this.reverse.remove(session.getId());
                    if (sid != null) {
                        SslSessionConfig.this.sessions.remove(sid);
                    }
                }
            }

            @Override
            public void attributeAdded(Session session, String name, Object value) {
            }

            @Override
            public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
            }

            @Override
            public void attributeRemoved(Session session, String name, Object oldValue) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sessionIdChanged(Session session, String oldSessionId) {
                SslSessionConfig sslSessionConfig = SslSessionConfig.this;
                synchronized (sslSessionConfig) {
                    Key sid = (Key)SslSessionConfig.this.reverse.remove(session.getId());
                    if (sid != null) {
                        SslSessionConfig.this.sessions.remove(sid);
                    }
                }
            }
        });
    }

    public SslSessionConfig(SessionManager sessionManager) {
        this(null, sessionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        UndertowLogger.SESSION_LOGGER.tracef("Setting SSL session id %s on %s", (Object)sessionId, (Object)exchange);
        SSLSessionInfo sslSession = exchange.getConnection().getSslSessionInfo();
        if (sslSession == null) {
            if (this.fallbackSessionConfig != null) {
                this.fallbackSessionConfig.setSessionId(exchange, sessionId);
            }
        } else {
            Key key = new Key(sslSession.getSessionId());
            SslSessionConfig sslSessionConfig = this;
            synchronized (sslSessionConfig) {
                this.sessions.put(key, sessionId);
                this.reverse.put(sessionId, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
        UndertowLogger.SESSION_LOGGER.tracef("Clearing SSL session id %s on %s", (Object)sessionId, (Object)exchange);
        SSLSessionInfo sslSession = exchange.getConnection().getSslSessionInfo();
        if (sslSession == null) {
            if (this.fallbackSessionConfig != null) {
                this.fallbackSessionConfig.clearSession(exchange, sessionId);
            }
        } else {
            SslSessionConfig sslSessionConfig = this;
            synchronized (sslSessionConfig) {
                Key sid = this.reverse.remove(sessionId);
                if (sid != null) {
                    this.sessions.remove(sid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findSessionId(HttpServerExchange exchange) {
        SSLSessionInfo sslSession = exchange.getConnection().getSslSessionInfo();
        if (sslSession == null) {
            if (this.fallbackSessionConfig != null) {
                return this.fallbackSessionConfig.findSessionId(exchange);
            }
        } else {
            SslSessionConfig sslSessionConfig = this;
            synchronized (sslSessionConfig) {
                String sessionId = this.sessions.get(new Key(sslSession.getSessionId()));
                if (sessionId != null) {
                    UndertowLogger.SESSION_LOGGER.tracef("Found SSL session id %s on %s", (Object)sessionId, (Object)exchange);
                }
                return sessionId;
            }
        }
        return null;
    }

    @Override
    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        return this.findSessionId(exchange) != null ? SessionConfig.SessionCookieSource.SSL : SessionConfig.SessionCookieSource.NONE;
    }

    @Override
    public String rewriteUrl(String originalUrl, String sessionId) {
        return originalUrl;
    }

    private static final class Key {
        private final byte[] id;

        private Key(byte[] id) {
            this.id = id;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Key key = (Key)o2;
            return Arrays.equals(this.id, key.id);
        }

        public int hashCode() {
            return this.id != null ? Arrays.hashCode(this.id) : 0;
        }
    }
}

