/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpServerConnection;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class PipeliningBufferingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final int SHUTDOWN = 1;
    private static final int DELEGATE_SHUTDOWN = 2;
    private static final int FLUSHING = 8;
    private int state;
    private final ByteBufferPool pool;
    private PooledByteBuffer buffer;

    public PipeliningBufferingStreamSinkConduit(StreamSinkConduit next, ByteBufferPool pool) {
        super(next);
        this.pool = pool;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        boolean res;
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet(this.state, 8) && !(res = this.flushBuffer())) {
            return 0L;
        }
        PooledByteBuffer pooled = this.buffer;
        if (pooled == null) {
            this.buffer = pooled = this.pool.allocate();
        }
        ByteBuffer buffer = pooled.getBuffer();
        long total = Buffers.remaining(srcs, offset, length);
        if ((long)buffer.remaining() > total) {
            long put = total;
            Buffers.copy(buffer, srcs, offset, length);
            return put;
        }
        return this.flushBufferWithUserData(srcs, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        ByteBuffer buffer;
        boolean res;
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet(this.state, 8) && !(res = this.flushBuffer())) {
            return 0;
        }
        PooledByteBuffer pooled = this.buffer;
        if (pooled == null) {
            this.buffer = pooled = this.pool.allocate();
        }
        if ((buffer = pooled.getBuffer()).remaining() > src.remaining()) {
            int put = src.remaining();
            buffer.put(src);
            return put;
        }
        return (int)this.flushBufferWithUserData(new ByteBuffer[]{src}, 0, 1);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long flushBufferWithUserData(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        ByteBuffer byteBuffer = this.buffer.getBuffer();
        if (byteBuffer.position() == 0) {
            try {
                long l2 = ((StreamSinkConduit)this.next).write(byteBuffers, offset, length);
                return l2;
            }
            finally {
                this.buffer.close();
                this.buffer = null;
            }
        }
        if (!Bits.anyAreSet(this.state, 8)) {
            this.state |= 8;
            byteBuffer.flip();
        }
        int originalBufferedRemaining = byteBuffer.remaining();
        long toWrite = originalBufferedRemaining;
        ByteBuffer[] writeBufs = new ByteBuffer[length + 1];
        writeBufs[0] = byteBuffer;
        for (int i2 = offset; i2 < offset + length; ++i2) {
            writeBufs[i2 + 1 - offset] = byteBuffers[i2];
            toWrite += (long)byteBuffers[i2].remaining();
        }
        long res = 0L;
        long written = 0L;
        do {
            res = ((StreamSinkConduit)this.next).write(writeBufs, 0, writeBufs.length);
            written += res;
            if (res != 0L) continue;
            if (written > (long)originalBufferedRemaining) {
                this.buffer.close();
                this.buffer = null;
                this.state &= 0xFFFFFFF7;
                return written - (long)originalBufferedRemaining;
            }
            return 0L;
        } while (written < toWrite);
        this.buffer.close();
        this.buffer = null;
        this.state &= 0xFFFFFFF7;
        return written - (long)originalBufferedRemaining;
    }

    public boolean flushPipelinedData() throws IOException {
        if (this.buffer == null || this.buffer.getBuffer().position() == 0 && Bits.allAreClear(this.state, 8)) {
            return ((StreamSinkConduit)this.next).flush();
        }
        return this.flushBuffer();
    }

    public void setupPipelineBuffer(HttpServerExchange exchange) {
        ((HttpServerConnection)exchange.getConnection()).getChannel().getSinkChannel().setConduit(this);
    }

    private boolean flushBuffer() throws IOException {
        if (this.buffer == null) {
            return ((StreamSinkConduit)this.next).flush();
        }
        ByteBuffer byteBuffer = this.buffer.getBuffer();
        if (!Bits.anyAreSet(this.state, 8)) {
            this.state |= 8;
            byteBuffer.flip();
        }
        while (byteBuffer.hasRemaining()) {
            if (((StreamSinkConduit)this.next).write(byteBuffer) != 0) continue;
            return false;
        }
        if (!((StreamSinkConduit)this.next).flush()) {
            return false;
        }
        this.buffer.close();
        this.buffer = null;
        this.state &= 0xFFFFFFF7;
        return true;
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (this.buffer != null && this.buffer.getBuffer().hasRemaining()) {
            return;
        }
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }

    @Override
    public void awaitWritable() throws IOException {
        if (this.buffer != null) {
            if (this.buffer.getBuffer().hasRemaining()) {
                return;
            }
            ((StreamSinkConduit)this.next).awaitWritable();
        }
    }

    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            if (!this.flushBuffer()) {
                return false;
            }
            if (Bits.anyAreSet(this.state, 1) && Bits.anyAreClear(this.state, 2)) {
                this.state |= 2;
                ((StreamSinkConduit)this.next).terminateWrites();
            }
            return ((StreamSinkConduit)this.next).flush();
        }
        return true;
    }

    @Override
    public void terminateWrites() throws IOException {
        this.state |= 1;
        if (this.buffer == null) {
            this.state |= 2;
            ((StreamSinkConduit)this.next).terminateWrites();
        }
    }

    @Override
    public void truncateWrites() throws IOException {
        try {
            ((StreamSinkConduit)this.next).truncateWrites();
        }
        finally {
            if (this.buffer != null) {
                this.buffer.close();
            }
        }
    }

    public void exchangeComplete(HttpServerExchange exchange) {
        HttpServerConnection connection = (HttpServerConnection)exchange.getConnection();
        if (connection.getExtraBytes() == null || exchange.isUpgrade()) {
            this.performFlush(exchange, connection);
        } else {
            connection.getReadListener().exchangeComplete(exchange);
        }
    }

    void performFlush(final HttpServerExchange exchange, final HttpServerConnection connection) {
        try {
            final AbstractServerConnection.ConduitState oldState = connection.resetChannel();
            if (!this.flushPipelinedData()) {
                final StreamConnection channel = connection.getChannel();
                channel.getSinkChannel().setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)new ChannelListener<Channel>(){

                    @Override
                    public void handleEvent(Channel c2) {
                        try {
                            if (PipeliningBufferingStreamSinkConduit.this.flushPipelinedData()) {
                                channel.getSinkChannel().setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)null);
                                channel.getSinkChannel().suspendWrites();
                                connection.restoreChannel(oldState);
                                connection.getReadListener().exchangeComplete(exchange);
                            }
                        }
                        catch (IOException e2) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(e2);
                            IoUtils.safeClose((Closeable)channel);
                        }
                        catch (Throwable t2) {
                            UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t2);
                            IoUtils.safeClose((Closeable)channel);
                        }
                    }
                });
                connection.getChannel().getSinkChannel().resumeWrites();
                return;
            }
            connection.restoreChannel(oldState);
            connection.getReadListener().exchangeComplete(exchange);
        }
        catch (IOException e2) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e2);
            IoUtils.safeClose((Closeable)connection.getChannel());
        }
        catch (Throwable t2) {
            UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t2);
            IoUtils.safeClose((Closeable)connection.getChannel());
        }
    }
}

