/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowMessages;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.PathMatcher;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class HostTable<H> {
    private final Map<H, Set<Target>> hosts = new CopyOnWriteMap<H, Set<Target>>();
    private final Map<String, PathMatcher<Set<H>>> targets = new CopyOnWriteMap<String, PathMatcher<Set<H>>>();

    public synchronized HostTable addHost(H host) {
        if (this.hosts.containsKey(host)) {
            throw UndertowMessages.MESSAGES.hostAlreadyRegistered(host);
        }
        this.hosts.put(host, new CopyOnWriteArraySet());
        return this;
    }

    public synchronized HostTable removeHost(H host) {
        Set<Target> targets = this.hosts.remove(host);
        for (Target target : targets) {
            this.removeRoute(host, target.virtualHost, target.contextPath);
        }
        return this;
    }

    public synchronized HostTable addRoute(H host, String virtualHost, String contextPath) {
        Set<H> hostSet;
        Set<Target> hostData = this.hosts.get(host);
        if (hostData == null) {
            throw UndertowMessages.MESSAGES.hostHasNotBeenRegistered(host);
        }
        hostData.add(new Target(virtualHost, contextPath));
        PathMatcher<Set<Object>> paths = this.targets.get(virtualHost);
        if (paths == null) {
            paths = new PathMatcher();
            this.targets.put(virtualHost, paths);
        }
        if ((hostSet = paths.getPrefixPath(contextPath)) == null) {
            hostSet = new CopyOnWriteArraySet<H>();
            paths.addPrefixPath(contextPath, hostSet);
        }
        hostSet.add(host);
        return this;
    }

    public synchronized HostTable removeRoute(H host, String virtualHost, String contextPath) {
        PathMatcher<Set<H>> paths;
        Set<Target> hostData = this.hosts.get(host);
        if (hostData != null) {
            hostData.remove(new Target(virtualHost, contextPath));
        }
        if ((paths = this.targets.get(virtualHost)) == null) {
            return this;
        }
        Set<H> hostSet = paths.getPrefixPath(contextPath);
        if (hostSet == null) {
            return this;
        }
        hostSet.remove(host);
        if (hostSet.isEmpty()) {
            paths.removePrefixPath(contextPath);
        }
        return this;
    }

    public Set<H> getHostsForTarget(String hostName, String path) {
        PathMatcher<Set<H>> matcher = this.targets.get(hostName);
        if (matcher == null) {
            return null;
        }
        return matcher.match(path).getValue();
    }

    private static final class Target {
        final String virtualHost;
        final String contextPath;

        private Target(String virtualHost, String contextPath) {
            this.virtualHost = virtualHost;
            this.contextPath = contextPath;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Target target = (Target)o2;
            if (this.contextPath != null ? !this.contextPath.equals(target.contextPath) : target.contextPath != null) {
                return false;
            }
            return !(this.virtualHost != null ? !this.virtualHost.equals(target.virtualHost) : target.virtualHost != null);
        }

        public int hashCode() {
            int result = this.virtualHost != null ? this.virtualHost.hashCode() : 0;
            result = 31 * result + (this.contextPath != null ? this.contextPath.hashCode() : 0);
            return result;
        }
    }
}

