/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;

public final class StoredResponseStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    public static final AttachmentKey<byte[]> RESPONSE = AttachmentKey.create(byte[].class);
    private ByteArrayOutputStream outputStream;
    private final HttpServerExchange exchange;

    public StoredResponseStreamSinkConduit(StreamSinkConduit next, HttpServerExchange exchange) {
        super(next);
        this.exchange = exchange;
        long length = exchange.getResponseContentLength();
        if (length <= 0L) {
            this.outputStream = new ByteArrayOutputStream();
        } else {
            if (length > Integer.MAX_VALUE) {
                throw UndertowMessages.MESSAGES.responseTooLargeToBuffer(length);
            }
            this.outputStream = new ByteArrayOutputStream((int)length);
        }
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int start = src.position();
        int ret = super.write(src);
        for (int i2 = start; i2 < start + ret; ++i2) {
            this.outputStream.write(src.get(i2));
        }
        return ret;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long ret;
        int[] starts = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            starts[i2] = srcs[i2 + offs].position();
        }
        long rem = ret = super.write(srcs, offs, len);
        for (int i3 = 0; i3 < len; ++i3) {
            ByteBuffer buf = srcs[i3 + offs];
            for (int pos = starts[i3]; rem > 0L && pos <= buf.position(); ++pos, --rem) {
                this.outputStream.write(buf.get(pos));
            }
        }
        return ret;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        int start = src.position();
        int ret = super.writeFinal(src);
        for (int i2 = start; i2 < start + ret; ++i2) {
            this.outputStream.write(src.get(i2));
        }
        if (!src.hasRemaining()) {
            this.exchange.putAttachment(RESPONSE, this.outputStream.toByteArray());
            this.outputStream = null;
        }
        return ret;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long ret;
        int[] starts = new int[len];
        long toWrite = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            starts[i2] = srcs[i2 + offs].position();
            toWrite += (long)srcs[i2 + offs].remaining();
        }
        long rem = ret = super.write(srcs, offs, len);
        for (int i3 = 0; i3 < len; ++i3) {
            ByteBuffer buf = srcs[i3 + offs];
            for (int pos = starts[i3]; rem > 0L && pos <= buf.position(); ++pos, --rem) {
                this.outputStream.write(buf.get(pos));
            }
        }
        if (toWrite == ret) {
            this.exchange.putAttachment(RESPONSE, this.outputStream.toByteArray());
            this.outputStream = null;
        }
        return ret;
    }

    @Override
    public void terminateWrites() throws IOException {
        this.exchange.putAttachment(RESPONSE, this.outputStream.toByteArray());
        this.outputStream = null;
        super.terminateWrites();
    }
}

