select "catalog"                       as specific_catalog,
       "schema"                        as specific_schema,
       routine                         as specific_name,
       ordinal                         as ordinal_position,
       mode                            as parameter_mode,
       is_result,
       'NO'                            as as_locator,
       name                            as parameter_name,
       data_type,
       character_maximum_length,
       character_octet_length,
       cast(null as varchar)           as collation_catalog,
       cast(null as varchar)           as collation_schema,
       cast(null as varchar)           as collation_name,
       s.default_character_set_catalog as character_set_catalog,
       s.default_character_set_schema  as character_set_schema,
       s.default_character_set_name    as character_set_name,
       "precision"                     as numeric_precision,
       numeric_precision_radix,
       scale                           as numeric_scale,
       CAST(null as INTEGER)           as datetime_precision,
       CAST(null as INTEGER)           as interval_type,
       CAST(null as INTEGER)           as interval_precision,
       "catalog"                       as user_defined_type_catalog,
       "schema"                        as user_defined_type_schema,
       "name"                          as user_defined_type_name,
       CAST(null as VARCHAR)           as scope_catalog,
       CAST(null as VARCHAR)           as scope_schema,
       CAST(null as VARCHAR)           as scope_name
from information_schema.pdx_routine_parameters r
         left join information_schema.pdx_schemata s
                   on s.catalog_name = r.catalog and s.schema_name = r.schema