/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.repository.pegeldaten;

import java.sql.Connection;
import java.util.List;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Alarme;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Aufgaben;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Beobachtung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Festpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Funktion;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Geographie;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Hauptwerte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Nullpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbezeichnungen;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Status;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Verwaltung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Vorg\u00e4nger;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.GeneralRepository;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.InsertRepository;

public class KerndatenRepository
extends InsertRepository {
    public final GeneralRepository generalRepository;

    public KerndatenRepository(Connection connection, GeneralRepository generalRepository) {
        this.connection = connection;
        this.generalRepository = generalRepository;
    }

    public void speicherePegelbezeichnungen(List<Pegelbezeichnungen> pegelbezeichnungen) {
        String sql = "INSERT INTO pegeldaten.sd_kd_pegelbezeichnung (metadaten_id, gueltig_von, standort, gewaesser) VALUES (?, ?, ?, ?)";
        this.handleMultiInsertConnection("Pegelbezeichnung", "INSERT INTO pegeldaten.sd_kd_pegelbezeichnung (metadaten_id, gueltig_von, standort, gewaesser) VALUES (?, ?, ?, ?)", pegelbezeichnungen, (stmt, pegelbezeichnung, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(pegelbezeichnung.metadaten));
            stmt.setTimestamp(index++, pegelbezeichnung.gueltig_von);
            stmt.setString(index++, pegelbezeichnung.standort);
            stmt.setString(index++, pegelbezeichnung.gewaesser);
        });
    }

    public void speichereNullpunkte(List<Nullpunkte> nullpunkte) {
        this.generalRepository.erweitereVermessungssysteme();
        String sql = "INSERT INTO pegeldaten.sd_kd_vermessung_nullpunkte (metadaten_id, gueltig_von, pegelnullpunkt_vermessungsergebnis, vermessungssystem_vermessungsergebnis_nr, pegelnullpunkt, vermessungssystem_nr) VALUES (?, ?, ?, ?, ?, 7)";
        this.handleMultiInsertConnection("Nullpunkte", "INSERT INTO pegeldaten.sd_kd_vermessung_nullpunkte (metadaten_id, gueltig_von, pegelnullpunkt_vermessungsergebnis, vermessungssystem_vermessungsergebnis_nr, pegelnullpunkt, vermessungssystem_nr) VALUES (?, ?, ?, ?, ?, 7)", nullpunkte, (stmt, nullpunkt, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(nullpunkt.metadaten));
            stmt.setTimestamp(index++, nullpunkt.gueltig_von);
            stmt.setFloat(index++, nullpunkt.nullpunkt);
            stmt.setInt(index++, nullpunkt.vermessungssystem_nr);
            if (nullpunkt.vermessungssystem_nr == 7) {
                stmt.setFloat(index++, nullpunkt.nullpunkt);
            } else {
                stmt.setNull(index++, 6);
            }
        });
    }

    public void speichereVorg\u00e4nger(List<Vorg\u00e4nger> vorg\u00e4ngerListe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_kette_vorgaengerhistorie (metadaten_id, gueltig_von, vorgaenger_nr) VALUES (?, ?, ?)";
        this.handleMultiInsertConnection("Vorg\u00e4nger", "INSERT INTO pegeldaten.sd_kd_kette_vorgaengerhistorie (metadaten_id, gueltig_von, vorgaenger_nr) VALUES (?, ?, ?)", vorg\u00e4ngerListe, (stmt, vorg\u00e4nger, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(vorg\u00e4nger.metadaten));
            stmt.setTimestamp(index++, vorg\u00e4nger.gueltig_von);
            stmt.setInt(index++, vorg\u00e4nger.vorg\u00e4nger);
        });
    }

    public void speichereNachfolger(List<Vorg\u00e4nger> vorg\u00e4ngerListe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_kette_vorgaengerhistorie (metadaten_id, gueltig_von, nachfolger_nr) VALUES (?, ?, ?)";
        this.handleMultiInsertConnection("Nachfolger", "INSERT INTO pegeldaten.sd_kd_kette_vorgaengerhistorie (metadaten_id, gueltig_von, nachfolger_nr) VALUES (?, ?, ?)", vorg\u00e4ngerListe, (stmt, vorg\u00e4nger, index) -> {
            int nachfolger = vorg\u00e4nger.metadaten.messstellen_nr;
            vorg\u00e4nger.metadaten.messstellen_nr = vorg\u00e4nger.vorg\u00e4nger;
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(vorg\u00e4nger.metadaten));
            stmt.setTimestamp(index++, vorg\u00e4nger.gueltig_von);
            stmt.setInt(index++, nachfolger);
        });
    }

    public void speichereBeobachtung(List<Beobachtung> beobachtungen) {
        String sql = "INSERT INTO pegeldaten.sd_kd_beobachtung (metadaten_id, gueltig_von, beobachtung_nr) VALUES (?, ?, ?)";
        this.handleMultiInsertConnection("Beobachtung", "INSERT INTO pegeldaten.sd_kd_beobachtung (metadaten_id, gueltig_von, beobachtung_nr) VALUES (?, ?, ?)", beobachtungen, (stmt, beobachtung, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(beobachtung.metadaten));
            stmt.setTimestamp(index++, beobachtung.gueltig_von);
            stmt.setInt(index++, beobachtung.beobachtung_nr);
        });
    }

    public void speichereVerwaltungen(List<Verwaltung> verwaltungen) {
        this.generalRepository.erweitereFlussgebiet();
        this.generalRepository.erweitereBearbeitungsgebiet();
        this.generalRepository.erweitereBetreiber();
        this.generalRepository.erweitereEigent\u00fcmer();
        String sql = "INSERT INTO pegeldaten.sd_kd_verwaltung (metadaten_id, gueltig_von, bearbeitungsgebiet_nr, gebietskennzahl, flussgebiet_nr, flussgebietskennzahl, wrrl_wk, wsv_id, betreiber_nr, eigentuemer_nr) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Verwaltung", "INSERT INTO pegeldaten.sd_kd_verwaltung (metadaten_id, gueltig_von, bearbeitungsgebiet_nr, gebietskennzahl, flussgebiet_nr, flussgebietskennzahl, wrrl_wk, wsv_id, betreiber_nr, eigentuemer_nr) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", verwaltungen, (stmt, verwaltung, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(verwaltung.metadaten));
            stmt.setTimestamp(index++, verwaltung.gueltig_von);
            stmt.setInt(index++, verwaltung.bearbeitungsgebiet_nr);
            stmt.setLong(index++, verwaltung.gebietskennzahl);
            stmt.setInt(index++, verwaltung.flussgebiets_nr);
            stmt.setLong(index++, verwaltung.flussgebietskennzahl);
            stmt.setString(index++, verwaltung.wrrl_wk);
            stmt.setInt(index++, verwaltung.wsv_id);
            stmt.setInt(index++, verwaltung.betreiber_nr);
            stmt.setInt(index++, verwaltung.eigentuemer_nr);
        });
    }

    public void speichereStatus(List<Status> statusListe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_status (metadaten_id, gueltig_von, status, allgemeiner_hinweistext) VALUES (?, ?, ?, ?)";
        this.handleMultiInsertConnection("Status", "INSERT INTO pegeldaten.sd_kd_status (metadaten_id, gueltig_von, status, allgemeiner_hinweistext) VALUES (?, ?, ?, ?)", statusListe, (stmt, status, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(status.metadaten));
            stmt.setTimestamp(index++, status.gueltig_von);
            stmt.setInt(index++, status.status_nr);
            stmt.setString(index++, status.hinweis);
        });
    }

    public void speichereAlarme(List<Alarme> alarme) {
        String sql = "INSERT INTO pegeldaten.sd_alarme_werte (alarme_id, meldewert, typ_nr, hmo_nr) VALUES (?, ?, ?, ?)";
        for (Alarme alarm : alarme) {
            int alarm_id = this.speichereAlarm(alarm);
            this.handleMultiInsertConnection("Alarme", "INSERT INTO pegeldaten.sd_alarme_werte (alarme_id, meldewert, typ_nr, hmo_nr) VALUES (?, ?, ?, ?)", alarm.alarme, false, (stmt, alarmwerte, index) -> {
                stmt.setInt(index++, alarm_id);
                stmt.setInt(index++, alarmwerte.meldewert);
                stmt.setInt(index++, alarmwerte.typ_nr);
                stmt.setInt(index++, alarmwerte.hmo_nr);
            });
        }
        System.out.printf("Alarme importiert: %s%n", alarme.size());
    }

    public int speichereAlarm(Alarme alarme) {
        String sql = "INSERT INTO pegeldaten.sd_kd_alarme (metadaten_id, gueltig_von) VALUES (?, ?)";
        return this.handleSingleInsertConnection("Alarm", "INSERT INTO pegeldaten.sd_kd_alarme (metadaten_id, gueltig_von) VALUES (?, ?)", (stmt, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(alarme.metadaten));
            stmt.setTimestamp(index++, alarme.gueltig_von);
        });
    }

    public void speichereFestpunkte(List<Festpunkte> festpunkte) {
        String sql = "INSERT INTO pegeldaten.sd_festpunkte_werte (festpunkte_id, nr, rechtswert, hochwert, massgeblich_nr) VALUES (?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Festpunkte", "INSERT INTO pegeldaten.sd_festpunkte_werte (festpunkte_id, nr, rechtswert, hochwert, massgeblich_nr) VALUES (?, ?, ?, ?, ?)", festpunkte, (stmt, festpunkt, index) -> {
            int festpunkt_id = this.speichereFestpunkt((Festpunkte)festpunkt);
            stmt.setInt(index++, festpunkt_id);
            stmt.setInt(index++, festpunkt.nr);
            stmt.setInt(index++, festpunkt.rechtswert);
            stmt.setInt(index++, festpunkt.hochwert);
            stmt.setInt(index++, festpunkt.massgeblich_nr);
        });
    }

    public int speichereFestpunkt(Festpunkte festpunkte) {
        String sql = "INSERT INTO pegeldaten.sd_kd_vermessung_festpunkte (metadaten_id, gueltig_von) VALUES (?, ?)";
        return this.handleSingleInsertConnection("Festpunkt", "INSERT INTO pegeldaten.sd_kd_vermessung_festpunkte (metadaten_id, gueltig_von) VALUES (?, ?)", (stmt, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(festpunkte.metadaten));
            stmt.setTimestamp(index++, festpunkte.gueltig_von);
        });
    }

    public void speichereGeographie(List<Geographie> geographieListe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_geographie (metadaten_id, gueltig_von, einzugsgebiet, einzugsgebiet_bundesland, quelle_einzugsgebiet_nr, gewaesserkennzahl, stationierung) VALUES (?, ?, ?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Geographie", "INSERT INTO pegeldaten.sd_kd_geographie (metadaten_id, gueltig_von, einzugsgebiet, einzugsgebiet_bundesland, quelle_einzugsgebiet_nr, gewaesserkennzahl, stationierung) VALUES (?, ?, ?, ?, ?, ?, ?)", geographieListe, (stmt, geographie, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(geographie.metadaten));
            stmt.setTimestamp(index++, geographie.gueltig_von);
            stmt.setFloat(index++, geographie.einzugsgebiet);
            stmt.setFloat(index++, geographie.einzugsgebiet_bundesland);
            stmt.setInt(index++, geographie.quelle_einzugsgebiet_nr);
            stmt.setLong(index++, geographie.gewaesserkennzahl);
            stmt.setFloat(index++, geographie.stationierung);
        });
    }

    public void speichereAufgaben(List<Aufgaben> aufgaben) {
        this.generalRepository.erweitereSonstigeAufgaben();
        String sqlSonstige = "INSERT INTO pegeldaten.sd_aufgaben_sonstige (aufgaben_id, sonstige_nr) VALUES (?, ?)";
        String sqlHydro = "INSERT INTO pegeldaten.sd_aufgaben_hydrolog_messnetz (aufgaben_id, hydrologisches_messnetz_nr) VALUES (?, ?)";
        for (Aufgaben aufgabe : aufgaben) {
            int aufgabe_id = this.speichereAufgabe(aufgabe);
            this.handleMultiInsertConnection("Sonstige Aufgaben", "INSERT INTO pegeldaten.sd_aufgaben_sonstige (aufgaben_id, sonstige_nr) VALUES (?, ?)", aufgabe.sonstige, false, (stmt, sonstige, index) -> {
                stmt.setInt(index++, aufgabe_id);
                stmt.setInt(index++, sonstige.sonstige_nr);
            });
            this.handleMultiInsertConnection("Aufgaben hydrologisches Messnetz", "INSERT INTO pegeldaten.sd_aufgaben_hydrolog_messnetz (aufgaben_id, hydrologisches_messnetz_nr) VALUES (?, ?)", aufgabe.hydro, false, (stmt, hydro, index) -> {
                stmt.setInt(index++, aufgabe_id);
                stmt.setInt(index++, hydro.hydrologisches_messnetz_nr);
            });
        }
        System.out.printf("Aufgaben importiert: %s%n", aufgaben.size());
    }

    public int speichereAufgabe(Aufgaben aufgabe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_aufgaben (metadaten_id, gueltig_von) VALUES (?, ?)";
        return this.handleSingleInsertConnection("Aufgabe", "INSERT INTO pegeldaten.sd_kd_aufgaben (metadaten_id, gueltig_von) VALUES (?, ?)", (stmt, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(aufgabe.metadaten));
            stmt.setTimestamp(index++, aufgabe.gueltig_von);
        });
    }

    public void speichereFunktion(List<Funktion> funktionen) {
        this.generalRepository.erweiterePegeltyp();
        String sql = "INSERT INTO pegeldaten.sd_kd_funktion (metadaten_id, gueltig_von, pegeltyp_nr, messnetz_nr) VALUES (?, ?, ?, ?)";
        this.handleMultiInsertConnection("Funktion", "INSERT INTO pegeldaten.sd_kd_funktion (metadaten_id, gueltig_von, pegeltyp_nr, messnetz_nr) VALUES (?, ?, ?, ?)", funktionen, (stmt, funktion, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(funktion.metadaten));
            stmt.setTimestamp(index++, funktion.gueltig_von);
            stmt.setFloat(index++, funktion.pegeltyp_nr);
            stmt.setInt(index++, funktion.messnetz_nr);
        });
    }

    public void speichereHauptwerteW(List<Hauptwerte> hauptwerte) {
        String sql = "INSERT INTO pegeldaten.sd_kd_hauptwerte_wasserstand (metadaten_id, gueltig_von, bezugsperiode_von, bezugsperiode_bis, nw, nw_jahr, mnw, mw, mhw, hw, hw_jahr, nnw, nnw_datum, hhw, hhw_datum) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Hauptwerte W", "INSERT INTO pegeldaten.sd_kd_hauptwerte_wasserstand (metadaten_id, gueltig_von, bezugsperiode_von, bezugsperiode_bis, nw, nw_jahr, mnw, mw, mhw, hw, hw_jahr, nnw, nnw_datum, hhw, hhw_datum) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", hauptwerte, (stmt, hauptwert, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(hauptwert.metadaten));
            stmt.setTimestamp(index++, hauptwert.gueltig_von);
            stmt.setInt(index++, hauptwert.start);
            stmt.setInt(index++, hauptwert.end);
            stmt.setInt(index++, (int)hauptwert.n);
            stmt.setInt(index++, hauptwert.nJahr);
            stmt.setInt(index++, (int)hauptwert.mn);
            stmt.setInt(index++, (int)hauptwert.m);
            stmt.setInt(index++, (int)hauptwert.mh);
            stmt.setInt(index++, (int)hauptwert.h);
            stmt.setInt(index++, hauptwert.hJahr);
            stmt.setInt(index++, (int)hauptwert.nn);
            stmt.setDate(index++, hauptwert.nnDatum);
            stmt.setInt(index++, (int)hauptwert.hh);
            stmt.setDate(index++, hauptwert.hhDatum);
        });
    }

    public void speichereHauptwerteQ(List<Hauptwerte> hauptwerte) {
        String sql = "INSERT INTO pegeldaten.sd_kd_hauptwerte_durchfluss (metadaten_id, gueltig_von, bezugsperiode_von, bezugsperiode_bis, nq, nq_jahr, mnq, mq, mhq, hq, hq_jahr, nnq, nnq_datum, hhq, hhq_datum) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Hauptwerte Q", "INSERT INTO pegeldaten.sd_kd_hauptwerte_durchfluss (metadaten_id, gueltig_von, bezugsperiode_von, bezugsperiode_bis, nq, nq_jahr, mnq, mq, mhq, hq, hq_jahr, nnq, nnq_datum, hhq, hhq_datum) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", hauptwerte, (stmt, hauptwert, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(hauptwert.metadaten));
            stmt.setTimestamp(index++, hauptwert.gueltig_von);
            stmt.setInt(index++, hauptwert.start);
            stmt.setInt(index++, hauptwert.end);
            stmt.setDouble(index++, hauptwert.n);
            stmt.setInt(index++, hauptwert.nJahr);
            stmt.setDouble(index++, hauptwert.mn);
            stmt.setDouble(index++, hauptwert.m);
            stmt.setDouble(index++, hauptwert.mh);
            stmt.setDouble(index++, hauptwert.h);
            stmt.setInt(index++, hauptwert.hJahr);
            stmt.setDouble(index++, hauptwert.nn);
            stmt.setDate(index++, hauptwert.nnDatum);
            stmt.setDouble(index++, hauptwert.hh);
            stmt.setDate(index++, hauptwert.hhDatum);
        });
    }
}

