/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.repository.pegeldaten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Betriebspegel;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Bilder;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Funktion;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Metadaten;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbezeichnungen;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Status;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.InsertRepository;

public class GeneralRepository
extends InsertRepository {
    public GeneralRepository(Connection connection) {
        this.connection = connection;
    }

    public int speichereMetadaten(Metadaten metadaten) {
        String sql = "INSERT INTO pegeldaten.sd_metadaten (messstelle_nr, kategorie_id, ersteller_nr, erfasst_am, bemerkung) VALUES (?, ?, ?, ?, ?)";
        return this.handleSingleInsertConnection("Metadaten", "INSERT INTO pegeldaten.sd_metadaten (messstelle_nr, kategorie_id, ersteller_nr, erfasst_am, bemerkung) VALUES (?, ?, ?, ?, ?)", (stmt, index) -> {
            stmt.setLong(index++, metadaten.messstellen_nr);
            stmt.setInt(index++, metadaten.kategorie_id);
            stmt.setInt(index++, metadaten.ersteller_nr);
            stmt.setDate(index++, metadaten.erfasst_am);
            stmt.setString(index++, metadaten.bemerkung);
        });
    }

    public void speichereMessstellen(List<Integer> messstellen) {
        String sql = "INSERT INTO pegeldaten.sd_messstellen (messstelle_nr) VALUES (?)";
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO pegeldaten.sd_messstellen (messstelle_nr) VALUES (?)");){
            for (Integer messstelle : messstellen) {
                int index = 1;
                stmt.setInt(index++, messstelle);
                stmt.addBatch();
            }
            stmt.executeBatch();
            System.out.printf("Messstellennummern importiert: %s%n", messstellen.size());
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Messstellen nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void erweitereVermessungssysteme() {
        String deleteSql = "DELETE FROM ohyd.sl_vermessungssystem WHERE vermessungssystem_nr in (9,10)";
        String sql = "INSERT INTO ohyd.sl_vermessungssystem (vermessungssystem_nr, vermessungssystem) VALUES (9, 'SNN76'),(10, 'SNN56')";
        try (PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM ohyd.sl_vermessungssystem WHERE vermessungssystem_nr in (9,10)");
             PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ohyd.sl_vermessungssystem (vermessungssystem_nr, vermessungssystem) VALUES (9, 'SNN76'),(10, 'SNN56')");){
            deleteStmt.execute();
            stmt.execute();
            System.out.println("# Vermessungssysteme erweitert");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Vermessungsysteme nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void erweitereFlussgebiet() {
        String deleteSql = "DELETE FROM pegeldaten.sl_flussgebiet WHERE flussgebiet_nr in (1,2,3,4)";
        String sql = "INSERT INTO pegeldaten.sl_flussgebiet (flussgebiet_nr, flussgebiet) VALUES (1, 'Warnow/Peene'),(2, 'Elbe'),(3, 'Oder'),(4, 'Schlei/Trave')";
        try (PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM pegeldaten.sl_flussgebiet WHERE flussgebiet_nr in (1,2,3,4)");
             PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO pegeldaten.sl_flussgebiet (flussgebiet_nr, flussgebiet) VALUES (1, 'Warnow/Peene'),(2, 'Elbe'),(3, 'Oder'),(4, 'Schlei/Trave')");){
            deleteStmt.execute();
            stmt.execute();
            System.out.println("# Flussgebiete erweitert");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Flussgebiete nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void erweitereBearbeitungsgebiet() {
        String deleteSql = "DELETE FROM ohyd.sl_flussgebiet";
        String sql = "INSERT INTO ohyd.sl_flussgebiet (flussgebiet_nr, flussgebiet) VALUES (0, '-'), (1, 'K\u00fcstengebiet West'),(2, 'Warnow'),(3, 'Peene'),(4, 'Elde/M\u00fcritz'),(5, 'Uecker/Zarow'),(6, 'Havel'),(7, 'K\u00fcstengebiet Ost'),(8, 'Oder'),(9, 'Stepenitz'),(10, 'Sude'),(11, 'Stettiner Haff')";
        try (PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM ohyd.sl_flussgebiet");
             PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ohyd.sl_flussgebiet (flussgebiet_nr, flussgebiet) VALUES (0, '-'), (1, 'K\u00fcstengebiet West'),(2, 'Warnow'),(3, 'Peene'),(4, 'Elde/M\u00fcritz'),(5, 'Uecker/Zarow'),(6, 'Havel'),(7, 'K\u00fcstengebiet Ost'),(8, 'Oder'),(9, 'Stepenitz'),(10, 'Sude'),(11, 'Stettiner Haff')");){
            deleteStmt.execute();
            stmt.execute();
            System.out.println("# Bearbeitungsgebiete erweitert");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Bearbeitungsgebiete nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void erweitereEigent\u00fcmer() {
        String deleteSql = "DELETE FROM ohyd.sl_gwd";
        String sql = "INSERT INTO ohyd.sl_gwd (gwd_nr, gwd_langname) VALUES (0, '-'), (1, 'StALU MS'),(2, 'StALU WM'),(3, 'StALU MM'),(4, 'StALU VP (UEM)'),(5, 'WSV'),(6, 'LOWO-ID 111'),(7, 'LOWO-ID 999'),(8, 'StALU VP (HST) '),(9, 'BB')";
        try (PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM ohyd.sl_gwd");
             PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ohyd.sl_gwd (gwd_nr, gwd_langname) VALUES (0, '-'), (1, 'StALU MS'),(2, 'StALU WM'),(3, 'StALU MM'),(4, 'StALU VP (UEM)'),(5, 'WSV'),(6, 'LOWO-ID 111'),(7, 'LOWO-ID 999'),(8, 'StALU VP (HST) '),(9, 'BB')");){
            deleteStmt.execute();
            stmt.execute();
            System.out.println("# Eigent\u00fcmer erweitert");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Eigent\u00fcmer nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void erweitereBetreiber() {
        String deleteSql = "DELETE FROM ohyd.sl_gwb";
        String sql = "INSERT INTO ohyd.sl_gwb (gwb_nr, gwb_langname) VALUES (0, '-'), (1, 'StALU MS'),(2, 'StALU WM'),(3, 'StALU MM'),(4, 'StALU VP (UEM)'),(5, 'WSV'),(6, 'LOWO-ID 111'),(7, 'LOWO-ID 999'),(8, 'StALU VP (HST) '),(9, 'BB')";
        try (PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM ohyd.sl_gwb");
             PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ohyd.sl_gwb (gwb_nr, gwb_langname) VALUES (0, '-'), (1, 'StALU MS'),(2, 'StALU WM'),(3, 'StALU MM'),(4, 'StALU VP (UEM)'),(5, 'WSV'),(6, 'LOWO-ID 111'),(7, 'LOWO-ID 999'),(8, 'StALU VP (HST) '),(9, 'BB')");){
            deleteStmt.execute();
            stmt.execute();
            System.out.println("# Betreiber erweitert");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Betreiber nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void erweitereMessgeraetBezeichnung() {
        String deleteSql = "DELETE FROM ohyd.sl_messgeraet_bezeichnung WHERE messgeraet_bezeichnung_nr in (1,2); DELETE FROM ohyd.sl_messgeraet_hersteller WHERE messgeraet_hersteller_nr in (0);";
        String herstellerSql = "INSERT INTO ohyd.sl_messgeraet_hersteller (messgeraet_hersteller_nr, messgeraet_hersteller) VALUES (0, 'unbekannt')";
        String sql = "INSERT INTO ohyd.sl_messgeraet_bezeichnung (messgeraet_bezeichnung_nr, messgeraet_messprinzip, messgeraet_hersteller) VALUES (1, 1, 0),(2, 3, 0)";
        try (PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM ohyd.sl_messgeraet_bezeichnung WHERE messgeraet_bezeichnung_nr in (1,2); DELETE FROM ohyd.sl_messgeraet_hersteller WHERE messgeraet_hersteller_nr in (0);");
             PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ohyd.sl_messgeraet_bezeichnung (messgeraet_bezeichnung_nr, messgeraet_messprinzip, messgeraet_hersteller) VALUES (1, 1, 0),(2, 3, 0)");
             PreparedStatement herstellerStmt = this.connection.prepareStatement("INSERT INTO ohyd.sl_messgeraet_hersteller (messgeraet_hersteller_nr, messgeraet_hersteller) VALUES (0, 'unbekannt')");){
            deleteStmt.execute();
            herstellerStmt.execute();
            stmt.execute();
            System.out.println("# Messgeraet Bezeichnung erweitert");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Messgeraet Bezeichnung nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void erweitereSonstigeAufgaben() {
        String deleteSql = "DELETE FROM ohyd.sl_sonderaufgabe WHERE sonderaufgabe_nr in (51,52,53,54,55,56,57,58,59)";
        String sql = "INSERT INTO ohyd.sl_sonderaufgabe (sonderaufgabe_nr, sonderaufgabe) VALUES (51, 'Operative Aufgaben'), (52, 'Wassermengenbewirtschaftung'), (53, '\u00dcberwachung der Gew\u00e4sserg\u00fcte'), (54, 'Eignung als Referenzmessstelle WRRL'), (55, 'Besondere hydrolog. Konstellationen'), (56, 'Markante Abflussregulierungen'), (57, 'Gr\u00f6\u00dfere Einzugsgebiete'), (58, 'Erlass-Pegel'), (59, 'Online-Pegel')";
        try (PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM ohyd.sl_sonderaufgabe WHERE sonderaufgabe_nr in (51,52,53,54,55,56,57,58,59)");
             PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ohyd.sl_sonderaufgabe (sonderaufgabe_nr, sonderaufgabe) VALUES (51, 'Operative Aufgaben'), (52, 'Wassermengenbewirtschaftung'), (53, '\u00dcberwachung der Gew\u00e4sserg\u00fcte'), (54, 'Eignung als Referenzmessstelle WRRL'), (55, 'Besondere hydrolog. Konstellationen'), (56, 'Markante Abflussregulierungen'), (57, 'Gr\u00f6\u00dfere Einzugsgebiete'), (58, 'Erlass-Pegel'), (59, 'Online-Pegel')");){
            deleteStmt.execute();
            stmt.execute();
            System.out.println("# Sonstige Aufgaben erweitert");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Sonstige Aufgaben nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void erweiterePegeltyp() {
        String deleteSql = "DELETE FROM ohyd.sl_pegeltyp";
        String sql = "INSERT INTO ohyd.sl_pegeltyp (pegeltyp_nr, pegeltyp, pegeltyp_wq) VALUES (0, 'unbekannt', ''), (1, 'Betriebspegel T', 'T'),(2, 'Betriebspegel Q und T', 'Q,T'),(3, 'Betriebspegel Q', 'Q'),(4, 'Betriebspegel W, Q und T', 'W,Q,T'),(5, 'Betriebspegel W und T', 'W,T'),(6, 'Betriebspegel W und Q', 'W,Q'),(7, 'Betriebspegel W', 'W'),(8, 'K\u00fcstengew\u00e4sserpegel T', 'T'),(9, 'K\u00fcstengew\u00e4sserpegel Q und T', 'Q,T'),(10, 'K\u00fcstengew\u00e4sserpegel Q', 'Q'),(11, 'K\u00fcstengew\u00e4sserpegel W, Q und T', 'W,Q,T'),(12, 'K\u00fcstengew\u00e4sserpegel W und T', 'W,T'),(13, 'K\u00fcstengew\u00e4sserpegel W und Q', 'W,Q'),(14, 'K\u00fcstengew\u00e4sserpegel W', 'W'),(15, 'Standgew\u00e4sserpegel T', 'T'),(16, 'Standgew\u00e4sserpegel Q und T', 'Q,T'),(17, 'Standgew\u00e4sserpegel Q', 'Q'),(18, 'Standgew\u00e4sserpegel W, Q und T', 'W,Q,T'),(19, 'Standgew\u00e4sserpegel W und T', 'W,T'),(20, 'Standgew\u00e4sserpegel W und Q', 'W,Q'),(21, 'Standgew\u00e4sserpegel W', 'W'),(22, 'Flie\u00dfgew\u00e4sserpegel T', 'T'),(23, 'Flie\u00dfgew\u00e4sserpegel Q und T', 'Q,T'),(24, 'Flie\u00dfgew\u00e4sserpegel Q', 'Q'),(25, 'Flie\u00dfgew\u00e4sserpegel W, Q und T', 'W,Q,T'),(26, 'Flie\u00dfgew\u00e4sserpegel W und T', 'W,T'),(27, 'Flie\u00dfgew\u00e4sserpegel W und Q', 'W,Q'),(28, 'Flie\u00dfgew\u00e4sserpegel W', 'W')";
        try (PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM ohyd.sl_pegeltyp");
             PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ohyd.sl_pegeltyp (pegeltyp_nr, pegeltyp, pegeltyp_wq) VALUES (0, 'unbekannt', ''), (1, 'Betriebspegel T', 'T'),(2, 'Betriebspegel Q und T', 'Q,T'),(3, 'Betriebspegel Q', 'Q'),(4, 'Betriebspegel W, Q und T', 'W,Q,T'),(5, 'Betriebspegel W und T', 'W,T'),(6, 'Betriebspegel W und Q', 'W,Q'),(7, 'Betriebspegel W', 'W'),(8, 'K\u00fcstengew\u00e4sserpegel T', 'T'),(9, 'K\u00fcstengew\u00e4sserpegel Q und T', 'Q,T'),(10, 'K\u00fcstengew\u00e4sserpegel Q', 'Q'),(11, 'K\u00fcstengew\u00e4sserpegel W, Q und T', 'W,Q,T'),(12, 'K\u00fcstengew\u00e4sserpegel W und T', 'W,T'),(13, 'K\u00fcstengew\u00e4sserpegel W und Q', 'W,Q'),(14, 'K\u00fcstengew\u00e4sserpegel W', 'W'),(15, 'Standgew\u00e4sserpegel T', 'T'),(16, 'Standgew\u00e4sserpegel Q und T', 'Q,T'),(17, 'Standgew\u00e4sserpegel Q', 'Q'),(18, 'Standgew\u00e4sserpegel W, Q und T', 'W,Q,T'),(19, 'Standgew\u00e4sserpegel W und T', 'W,T'),(20, 'Standgew\u00e4sserpegel W und Q', 'W,Q'),(21, 'Standgew\u00e4sserpegel W', 'W'),(22, 'Flie\u00dfgew\u00e4sserpegel T', 'T'),(23, 'Flie\u00dfgew\u00e4sserpegel Q und T', 'Q,T'),(24, 'Flie\u00dfgew\u00e4sserpegel Q', 'Q'),(25, 'Flie\u00dfgew\u00e4sserpegel W, Q und T', 'W,Q,T'),(26, 'Flie\u00dfgew\u00e4sserpegel W und T', 'W,T'),(27, 'Flie\u00dfgew\u00e4sserpegel W und Q', 'W,Q'),(28, 'Flie\u00dfgew\u00e4sserpegel W', 'W')");){
            deleteStmt.execute();
            stmt.execute();
            System.out.println("# Pegeltyp erweitert");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Pegeltyp nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void refreshMaterializedViews() {
        String sql = "refresh materialized view mv_sd_logger;refresh materialized view mv_sd_logger_kommunikation;refresh materialized view mv_sd_massgeb_gewaesserab;refresh materialized view mv_sd_messgeraet;refresh materialized view mv_sd_messgeraet_kommunikation;refresh materialized view mv_sd_nullpunkte;refresh materialized view mv_sd_pegelbau;refresh materialized view mv_sd_pegelschau;refresh materialized view mv_sd_relevante_werte;refresh materialized view mv_sd_ska;refresh materialized view mv_sd_standortqualitaet;refresh materialized view mv_sd_vorgaengerhistorie;refresh materialized view mv_sd_pegelbezeichnung;refresh materialized view mv_sd_aufgaben;refresh materialized view mv_sd_funktion;refresh materialized view mv_sd_beobachtung;refresh materialized view mv_sd_status;refresh materialized view mv_sd_geographie;refresh materialized view mv_sd_verwaltung;refresh materialized view mv_sd_pegeldaten;refresh materialized view mv_sd_hauptwerte_wasserstand;refresh materialized view mv_sd_hauptwerte_durchfluss;refresh materialized view mv_sd_hw_wiederkehr;refresh materialized view mv_sd_rueckstau;";
        try (PreparedStatement stmt = this.connection.prepareStatement("refresh materialized view mv_sd_logger;refresh materialized view mv_sd_logger_kommunikation;refresh materialized view mv_sd_massgeb_gewaesserab;refresh materialized view mv_sd_messgeraet;refresh materialized view mv_sd_messgeraet_kommunikation;refresh materialized view mv_sd_nullpunkte;refresh materialized view mv_sd_pegelbau;refresh materialized view mv_sd_pegelschau;refresh materialized view mv_sd_relevante_werte;refresh materialized view mv_sd_ska;refresh materialized view mv_sd_standortqualitaet;refresh materialized view mv_sd_vorgaengerhistorie;refresh materialized view mv_sd_pegelbezeichnung;refresh materialized view mv_sd_aufgaben;refresh materialized view mv_sd_funktion;refresh materialized view mv_sd_beobachtung;refresh materialized view mv_sd_status;refresh materialized view mv_sd_geographie;refresh materialized view mv_sd_verwaltung;refresh materialized view mv_sd_pegeldaten;refresh materialized view mv_sd_hauptwerte_wasserstand;refresh materialized view mv_sd_hauptwerte_durchfluss;refresh materialized view mv_sd_hw_wiederkehr;refresh materialized view mv_sd_rueckstau;");){
            stmt.execute();
            System.out.println("* Materialized Views aktualisiert *");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Materialized Views nicht aktualisieren: " + e.getMessage(), e);
        }
    }

    public void deleteAllStammdaten() {
        String sql = "truncate table SD_KD_STATUS;truncate table SD_KD_FUNKTION;truncate table SD_AUFGABEN_SONSTIGE;truncate table SD_ALARME_WERTE;truncate table SD_AUFGABEN_HYDROLOG_MESSNETZ;truncate table SD_AP_MGT_LOGGER_KOMMUNIKA;truncate table SD_KD_GEOGRAPHIE;truncate table SD_KD_PEGELBEZEICHNUNG;truncate table SD_KD_VERWALTUNG;truncate table SD_KD_BEOBACHTUNG;truncate table SD_REFERENZEN_WERTE;truncate table SD_MESSSTELLEN;truncate table SD_FESTPUNKTE_WERTE;truncate table SD_AP_MGT_LOGGER;truncate table SD_AP_MGT_MESSGERAET;truncate table SD_AP_VERFAHRANLAGEN_SKA;truncate table SD_KD_KETTE_VORGAENGERHISTORIE;truncate table SD_KD_PEGELBAU;truncate table SD_KD_VERMESSUNG_NULLPUNKTE;truncate table sd_ap_rueckstau;truncate table ohyd.photos;delete from SD_KD_ALARME;delete from SD_KD_AUFGABEN;delete from SD_AP_MGT_REFERENZ;delete from SD_KD_VERMESSUNG_FESTPUNKTE;delete from SD_METADATEN;delete from ohyd.messtelle_pegel where messtellen_nr = 1;";
        try (PreparedStatement stmt = this.connection.prepareStatement("truncate table SD_KD_STATUS;truncate table SD_KD_FUNKTION;truncate table SD_AUFGABEN_SONSTIGE;truncate table SD_ALARME_WERTE;truncate table SD_AUFGABEN_HYDROLOG_MESSNETZ;truncate table SD_AP_MGT_LOGGER_KOMMUNIKA;truncate table SD_KD_GEOGRAPHIE;truncate table SD_KD_PEGELBEZEICHNUNG;truncate table SD_KD_VERWALTUNG;truncate table SD_KD_BEOBACHTUNG;truncate table SD_REFERENZEN_WERTE;truncate table SD_MESSSTELLEN;truncate table SD_FESTPUNKTE_WERTE;truncate table SD_AP_MGT_LOGGER;truncate table SD_AP_MGT_MESSGERAET;truncate table SD_AP_VERFAHRANLAGEN_SKA;truncate table SD_KD_KETTE_VORGAENGERHISTORIE;truncate table SD_KD_PEGELBAU;truncate table SD_KD_VERMESSUNG_NULLPUNKTE;truncate table sd_ap_rueckstau;truncate table ohyd.photos;delete from SD_KD_ALARME;delete from SD_KD_AUFGABEN;delete from SD_AP_MGT_REFERENZ;delete from SD_KD_VERMESSUNG_FESTPUNKTE;delete from SD_METADATEN;delete from ohyd.messtelle_pegel where messtellen_nr = 1;");){
            stmt.execute();
            System.out.println("* Tabellen geleert *");
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte alte Stammdaten nicht l\u00f6schen: " + e.getMessage(), e);
        }
    }

    public Betriebspegel ladeBetriebspegel() {
        String sql = "SELECT messtellen_nr, standort, gewaesser, bemerkung_allgemein FROM ohyd.messtelle_pegel WHERE messtellen_nr not in (select messstelle_nr from sd_messstellen)";
        ArrayList<Integer> messstelle = new ArrayList<Integer>();
        ArrayList<Pegelbezeichnungen> pegelbezeichnung = new ArrayList<Pegelbezeichnungen>();
        ArrayList<Status> status = new ArrayList<Status>();
        ArrayList<Funktion> funktion = new ArrayList<Funktion>();
        try (PreparedStatement query = this.connection.prepareStatement("SELECT messtellen_nr, standort, gewaesser, bemerkung_allgemein FROM ohyd.messtelle_pegel WHERE messtellen_nr not in (select messstelle_nr from sd_messstellen)");
             ResultSet rs = query.executeQuery();){
            while (rs.next()) {
                int messstellen_nr = rs.getInt("messtellen_nr");
                String bemerkung = rs.getString("bemerkung_allgemein");
                String standort = rs.getString("standort");
                String gewaesser = rs.getString("gewaesser");
                messstelle.add(messstellen_nr);
                status.add(new Status(messstellen_nr, bemerkung, 1));
                pegelbezeichnung.add(new Pegelbezeichnungen(messstellen_nr, standort, gewaesser));
                funktion.add(new Funktion(messstellen_nr, 7));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Konnte Betriebspegel nicht aus SQL-Datenbank auslesen: %s", e.getMessage()), e);
        }
        return new Betriebspegel(messstelle, pegelbezeichnung, status, funktion);
    }

    public void speichereBilderOHYD(List<Bilder> bilder) {
        String sql = "INSERT INTO ohyd.photos (gauging_station_id, image_file_name) VALUES (?, ?)";
        this.handleMultiInsertConnection("Bilder", "INSERT INTO ohyd.photos (gauging_station_id, image_file_name) VALUES (?, ?)", bilder, (stmt, bild, index) -> {
            stmt.setInt(index++, bild.messstellen_nr);
            stmt.setString(index++, bild.name);
        });
    }
}

