/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.repository.sensormatrix;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.ExcelSensorMatrixLeser;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.SensorMatrix;
import luwa.marlin.importer.hydras.util.Logger;

public class SensorMatrixRepository {
    private final Path verzeichnis;
    private final Logger logger;
    public static final String ausweichm\u00f6glichkeit = "ansonsten";
    private static final String notwendigerPr\u00e4fix = "ab_";
    private static final String endung = ".xlsx";
    private static final String datumsformat = "yyyyMMdd_HHmm";

    public SensorMatrixRepository(Path verzeichnis, Logger logger) {
        this.verzeichnis = verzeichnis;
        this.logger = logger;
    }

    public Optional<SensorMatrix> zuZeitpunkt(LocalDateTime zeitpunkt) {
        File[] matrixDateien = this.verzeichnis.toFile().listFiles(SensorMatrixRepository.matrixExcelDateienFilter());
        if (matrixDateien == null) {
            return Optional.empty();
        }
        Optional<SensorMatrix> matrix = Optional.empty();
        for (File matrixDatei : matrixDateien) {
            boolean nachBisherigemFund;
            String nameOhneErweiterung = SensorMatrixRepository.dateinameOhneErweiterung(matrixDatei.getName());
            LocalDateTime g\u00fcltigAb = this.g\u00fcltigkeitVon(nameOhneErweiterung).orElse(LocalDateTime.MAX);
            LocalDateTime bisher = matrix.map(SensorMatrix::g\u00fcltigAb).orElse(LocalDateTime.MIN);
            boolean vorZeitpunkt = !g\u00fcltigAb.isAfter(zeitpunkt);
            boolean bl = nachBisherigemFund = !g\u00fcltigAb.isBefore(bisher);
            if (!vorZeitpunkt || !nachBisherigemFund) continue;
            ExcelSensorMatrixLeser sensorMatrixLeser = new ExcelSensorMatrixLeser(this.logger);
            try {
                matrix = Optional.of(sensorMatrixLeser.leseSensorMatrix(matrixDatei, g\u00fcltigAb));
            }
            catch (IOException e) {
                this.logger.logge("Konnte Sensor-Matrix aus Datei '" + matrixDatei.getName() + "' nicht lesen: " + e.getMessage());
                matrix = Optional.empty();
            }
        }
        return matrix;
    }

    private Optional<LocalDateTime> g\u00fcltigkeitVon(String dateiname) {
        String verarbeitbar = dateiname.toLowerCase();
        if (ausweichm\u00f6glichkeit.equals(verarbeitbar)) {
            return Optional.of(LocalDateTime.MIN);
        }
        if (!verarbeitbar.startsWith(notwendigerPr\u00e4fix)) {
            return Optional.empty();
        }
        String datum = verarbeitbar.substring(notwendigerPr\u00e4fix.length());
        return this.datumF\u00fcr(datum, datumsformat);
    }

    private Optional<LocalDateTime> datumF\u00fcr(String text, String datumsMuster) {
        Object verwendbar = text.length() < datumsMuster.length() ? text + "_0000" : text;
        try {
            return Optional.of(LocalDateTime.parse((CharSequence)verwendbar, DateTimeFormatter.ofPattern(datumsMuster)));
        }
        catch (DateTimeParseException e) {
            this.logger.logge("Fehlerhafte Datumsangabe '" + text + "' f\u00fcr Datumsformat " + datumsMuster + ": " + e.getMessage());
            return Optional.empty();
        }
    }

    private static String dateinameOhneErweiterung(String dateiname) {
        int punktIndex = dateiname.lastIndexOf(46);
        return punktIndex < 0 ? dateiname : dateiname.substring(0, punktIndex);
    }

    private static FilenameFilter matrixExcelDateienFilter() {
        return (verzeichnis, dateiname) -> dateiname.endsWith(endung);
    }
}

