/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.repository.pegeldaten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import luwa.marlin.importer.hydras.dom\u00e4ne.Notiz;
import luwa.marlin.importer.hydras.dom\u00e4ne.Parameter;
import luwa.marlin.importer.hydras.dom\u00e4ne.Sensornummer;
import luwa.marlin.importer.hydras.dom\u00e4ne.WeitereZeitreihe;
import luwa.marlin.importer.hydras.dom\u00e4ne.ZeitWert;
import luwa.marlin.importer.hydras.dom\u00e4ne.Zeitreihe;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.Zieltabelle;
import luwa.marlin.importer.hydras.repository.SqlHelpers;
import luwa.marlin.importer.hydras.util.Logdatei;

public class ZeitreihenRepository {
    private final Connection connection;

    public ZeitreihenRepository(Connection connection) {
        this.connection = connection;
    }

    public void f\u00fcgeZeitreiheEin(Zeitreihe zeitreihe, double skalierungsfaktor) {
        Zieltabelle zieltabelle = zeitreihe.zieltabelle();
        String sql = "INSERT INTO " + zieltabelle.tabellenname() + " (messtellen_nr, " + zieltabelle.zeitSpaltenname() + ", " + zieltabelle.wertSpaltenname() + ") VALUES (?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            List<ZeitWert> werte = zeitreihe.werte();
            for (ZeitWert wert : werte) {
                int index = 1;
                stmt.setLong(index++, zeitreihe.messstelle().nummer());
                SqlHelpers.setDateTime(stmt, index++, wert.zeit());
                SqlHelpers.setOptionalDouble(stmt, index++, this.skaliere(wert.wert(), skalierungsfaktor, zieltabelle));
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Zeitreihe nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    private Optional<Double> skaliere(Optional<Double> wert, double skalierungsfaktor, Zieltabelle zieltabelle) {
        double s = zieltabelle == Zieltabelle.Z_NIEDERSCHLAG ? skalierungsfaktor / 100.0 : skalierungsfaktor;
        return wert.map(w -> w * s);
    }

    public void f\u00fcgeWeitereZeitreiheEin(WeitereZeitreihe weitereZeitreihe) {
        Zeitreihe zeitreihe = weitereZeitreihe.zeitreihe();
        Zieltabelle zieltabelle = zeitreihe.zieltabelle();
        long weitereZeitreiheId = this.legeWeitereZeitreiheDefinitionAn(weitereZeitreihe);
        String sql = "INSERT INTO " + zieltabelle.tabellenname() + " (reihen_nr, " + zieltabelle.zeitSpaltenname() + ", " + zieltabelle.wertSpaltenname() + ") VALUES (?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            for (ZeitWert wert : zeitreihe.werte()) {
                int index = 1;
                stmt.setLong(index++, weitereZeitreiheId);
                SqlHelpers.setDateTime(stmt, index++, wert.zeit());
                SqlHelpers.setOptionalDouble(stmt, index++, wert.wert());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Weitere Zeitreihe nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    private long legeWeitereZeitreiheDefinitionAn(WeitereZeitreihe weitereZeitreihe) {
        long l;
        block8: {
            Zeitreihe zeitreihe = weitereZeitreihe.zeitreihe();
            Parameter parameter = weitereZeitreihe.parameter();
            String[] generatedKeyColumns = new String[]{"id"};
            String sql = "INSERT INTO " + parameter.tabelleWeitereZeitreihenDefinition() + " (messtellen_nr, name, beschreibung, geloescht) VALUES (?, ?, ?, ?)";
            PreparedStatement stmt = this.connection.prepareStatement(sql, generatedKeyColumns);
            try {
                int index = 1;
                stmt.setLong(index++, zeitreihe.messstelle().nummer());
                stmt.setString(index++, weitereZeitreihe.name());
                stmt.setString(index++, "");
                stmt.setInt(index++, 0);
                stmt.addBatch();
                stmt.execute();
                ResultSet generatedKeys = stmt.getGeneratedKeys();
                generatedKeys.next();
                l = generatedKeys.getLong(1);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Konnte Weitere-Zeitreihen-Definition nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
                }
            }
            stmt.close();
        }
        return l;
    }

    public void f\u00fcgeNotizenEin(List<Notiz> notizen) {
        String sql = "INSERT INTO z_pegelnotiz_haupt (messtellen_nr, notiz, zeit, notiztext) VALUES (?, ?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO z_pegelnotiz_haupt (messtellen_nr, notiz, zeit, notiztext) VALUES (?, ?, ?, ?)");){
            for (Notiz notiz : notizen) {
                int index = 1;
                stmt.setLong(index++, notiz.messstelle().nummer());
                stmt.setLong(index++, 0L);
                SqlHelpers.setDateTime(stmt, index++, notiz.zeit());
                Optional<Sensornummer> sensornummer = notiz.sensornummer();
                String text = sensornummer.map(sensor -> sensor.nummer() + ": " + notiz.text()).orElseGet(notiz::text);
                stmt.setString(index++, text);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Notizen nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void f\u00fcgeTerminwerteEin(List<Notiz> notizen, Zieltabelle zieltabelle, double skalierungsfaktor) {
        String sql = "INSERT INTO " + zieltabelle.tabellenname() + " (messtellen_nr, " + zieltabelle.zeitSpaltenname() + ", " + zieltabelle.wertSpaltenname() + ") VALUES (?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            for (Notiz notiz : notizen) {
                int index = 1;
                stmt.setLong(index++, notiz.messstelle().nummer());
                SqlHelpers.setDateTime(stmt, index++, notiz.zeit());
                SqlHelpers.setOptionalDouble(stmt, index++, this.skaliere(notiz.wert(), skalierungsfaktor, zieltabelle));
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Notiz-Terminwerte nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void l\u00f6scheAlleZeitreihen(Logdatei importLog) {
        for (Zieltabelle tabelle : Zieltabelle.values()) {
            try {
                this.l\u00f6scheTabelleninhalt(tabelle.tabellenname());
            }
            catch (Exception e) {
                importLog.logge("Tabelle " + tabelle.tabellenname() + " nicht gel\u00f6scht: " + e.getMessage());
            }
        }
    }

    public void l\u00f6scheAlleTerminwerte(Logdatei importLog) {
        List<Zieltabelle> terminwertTabellen = List.of(Zieltabelle.W_HAND_HAUPT, Zieltabelle.W_SYSTEM_HAUPT, Zieltabelle.Q_HAND_HAUPT, Zieltabelle.Q_SYSTEM_HAUPT);
        for (Zieltabelle tabelle : terminwertTabellen) {
            try {
                this.l\u00f6scheTabelleninhalt(tabelle.tabellenname());
            }
            catch (Exception e) {
                importLog.logge("Tabelle " + tabelle.tabellenname() + " nicht gel\u00f6scht: " + e.getMessage());
            }
        }
    }

    public void l\u00f6scheAlleNotizen() {
        this.l\u00f6scheTabelleninhalt("z_pegelnotiz_haupt");
    }

    private void l\u00f6scheTabelleninhalt(String tabellenname) {
        this.executeSQL("TRUNCATE TABLE " + tabellenname);
    }

    private void l\u00f6scheTabelleninhaltBis(Zieltabelle tabelle) {
        this.executeSQL("DELETE FROM " + tabelle.tabellenname() + " WHERE " + tabelle.zeitSpaltenname() + "<'2024-03-01'");
    }

    private void executeSQL(String sql) {
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte SQL-Query nicht ausf\u00fchren (" + sql + "): " + e.getMessage(), e);
        }
    }
}

