/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.repository.pegeldaten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import luwa.marlin.importer.hydras.dom\u00e4ne.Betreiber;
import luwa.marlin.importer.hydras.dom\u00e4ne.Eigent\u00fcmer;
import luwa.marlin.importer.hydras.dom\u00e4ne.Messstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.MessstelleStammdaten;

public class MessstellenRepository {
    private final Connection connection;
    private static final int statusAktiv = 1;
    private static final int messnetzLandespegel = 1;

    public MessstellenRepository(Connection connection) {
        this.connection = connection;
    }

    public void legeMessstellenAn(List<MessstelleStammdaten> messstellen) {
        String sql = "INSERT INTO messtelle_pegel (messtellen_nr, standort, gewaesser, status, gwb_nr, messnetz, bemerkung_allgemein) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO messtelle_pegel (messtellen_nr, standort, gewaesser, status, gwb_nr, messnetz, bemerkung_allgemein) VALUES (?, ?, ?, ?, ?, ?, ?)");){
            for (MessstelleStammdaten messstelleStammdaten : messstellen) {
                Optional<Messstelle> messstelle = Messstelle.ausPKZ(messstelleStammdaten.messstelle().pkz());
                if (messstelle.isEmpty()) continue;
                int index = 1;
                stmt.setLong(index++, messstelle.get().nummer());
                stmt.setString(index++, "");
                stmt.setString(index++, messstelleStammdaten.name());
                stmt.setInt(index++, 1);
                stmt.setLong(index++, messstelleStammdaten.betreiber().nummer());
                stmt.setInt(index++, 1);
                stmt.setString(index++, messstelleStammdaten.notiz().orElse(""));
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Messstellen nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void l\u00f6scheAlleMessstellen() {
        this.l\u00f6scheTabelleninhalt("messtelle_pegel");
    }

    public void l\u00f6scheAlleEigent\u00fcmer() {
        this.l\u00f6scheTabelleninhalt("sl_gwd");
    }

    public void l\u00f6scheAlleBetreiber() {
        this.l\u00f6scheTabelleninhalt("sl_gwb");
    }

    private void l\u00f6scheTabelleninhalt(String tabellenname) {
        this.executeSQL("TRUNCATE TABLE " + tabellenname + " CASCADE");
    }

    private void executeSQL(String sql) {
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte SQL-Query nicht ausf\u00fchren (" + sql + "): " + e.getMessage(), e);
        }
    }

    public void legeEigent\u00fcmerAn(List<Eigent\u00fcmer> eigent\u00fcmer) {
        String sql = "INSERT INTO sl_gwd (gwd_nr, gwd_kurzname, gwd_langname) VALUES (?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO sl_gwd (gwd_nr, gwd_kurzname, gwd_langname) VALUES (?, ?, ?)");){
            for (Eigent\u00fcmer e : eigent\u00fcmer) {
                int index = 1;
                stmt.setLong(index++, e.nummer());
                stmt.setString(index++, e.name());
                stmt.setString(index++, e.name());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Eigent\u00fcmer nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void legeBetreiberAn(List<Betreiber> betreiber) {
        String sql = "INSERT INTO sl_gwb (gwb_nr, gwd_nr, gwb_kurzname, gwb_langname) VALUES (?, ?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO sl_gwb (gwb_nr, gwd_nr, gwb_kurzname, gwb_langname) VALUES (?, ?, ?, ?)");){
            for (Betreiber b : betreiber) {
                int index = 1;
                stmt.setLong(index++, b.nummer());
                stmt.setLong(index++, b.eigent\u00fcmer().nummer());
                stmt.setString(index++, b.eigent\u00fcmer().name());
                stmt.setString(index++, b.eigent\u00fcmer().name());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Eigent\u00fcmer nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }
}

