/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.repository.pegeldaten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import luwa.marlin.importer.hydras.dom\u00e4ne.Abflusskurve;
import luwa.marlin.importer.hydras.dom\u00e4ne.Kurveng\u00fcltigkeit;
import luwa.marlin.importer.hydras.dom\u00e4ne.Messstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.WQPaar;
import luwa.marlin.importer.hydras.repository.SqlHelpers;

public class AbflusskurvenRepository {
    private final Connection connection;

    public AbflusskurvenRepository(Connection connection) {
        this.connection = connection;
    }

    public long speichereAbflusskurve(Abflusskurve abflusskurve) {
        long l;
        block8: {
            String[] generatedKeyColumns = new String[]{"id"};
            String sql = "INSERT INTO ak (messtellen_nr, kurve) VALUES (?, ?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ak (messtellen_nr, kurve) VALUES (?, ?)", generatedKeyColumns);
            try {
                int index = 1;
                stmt.setLong(index++, abflusskurve.messstelle().nummer());
                stmt.setString(index++, abflusskurve.name());
                stmt.execute();
                ResultSet generatedKeys = stmt.getGeneratedKeys();
                generatedKeys.next();
                long abflusskurvenId = generatedKeys.getLong(1);
                this.speichereAbfluskurvenTabelle(abflusskurve, abflusskurvenId);
                l = abflusskurvenId;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Konnte Abflusskurve nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
                }
            }
            stmt.close();
        }
        return l;
    }

    private void speichereAbfluskurvenTabelle(Abflusskurve abflusskurve, long abflusskurvenId) {
        String sql = "INSERT INTO ak_wert (kurve, w, q) VALUES (?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ak_wert (kurve, w, q) VALUES (?, ?, ?)");){
            for (WQPaar wqPaar : abflusskurve.tabelle()) {
                int index = 1;
                stmt.setLong(index++, abflusskurvenId);
                stmt.setDouble(index++, wqPaar.W());
                stmt.setDouble(index++, wqPaar.Q());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Werte f\u00fcr Abflusskurve mit ID " + abflusskurvenId + " nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void l\u00f6scheAlleAbflusskurven() {
        this.l\u00f6scheTabelleninhalt("ak");
        this.l\u00f6scheTabelleninhalt("ak_wert");
        this.l\u00f6scheTabelleninhalt("ak_gueltigkeit");
    }

    private void l\u00f6scheTabelleninhalt(String tabellenname) {
        this.executeSQL("TRUNCATE TABLE " + tabellenname);
    }

    private void executeSQL(String sql) {
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte SQL-Query nicht ausf\u00fchren (" + sql + "): " + e.getMessage(), e);
        }
    }

    public void speichereG\u00fcltigkeit(Messstelle messstelle, Kurveng\u00fcltigkeit g\u00fcltigkeit, long abflusskurvenId) {
        String sql = "INSERT INTO ak_gueltigkeit (messtellen_nr, kurve, von, bis) VALUES (?, ?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO ak_gueltigkeit (messtellen_nr, kurve, von, bis) VALUES (?, ?, ?, ?)");){
            int index = 1;
            stmt.setLong(index++, messstelle.nummer());
            stmt.setLong(index++, abflusskurvenId);
            SqlHelpers.setDateTime(stmt, index++, g\u00fcltigkeit.g\u00fcltigVon());
            SqlHelpers.setOptionalDateTime(stmt, index++, g\u00fcltigkeit.g\u00fcltigBis());
            stmt.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Abflusskurveng\u00fcltigkeit f\u00fcr Messstelle " + messstelle.nummer() + " nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }
}

