/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.repository.hydras;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import luwa.marlin.importer.hydras.dom\u00e4ne.ZeitWert;
import luwa.marlin.importer.hydras.dom\u00e4ne.Zeitzone;

public class HydrasZeitreihenRepository {
    private final Path csvVile;
    private final String separator = ";";
    private static final DateTimeFormatter datumsformat = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss").withZone(Zeitzone.zeitzoneMEZ);
    private static final NumberFormat zahlenformat = NumberFormat.getInstance(Locale.GERMANY);
    public static final String l\u00fcckeRepr\u00e4sentation = "---";

    public HydrasZeitreihenRepository(Path csvVile) {
        this.csvVile = csvVile;
    }

    public List<ZeitWert> werte() throws IOException, ParseException {
        List<String> zeilen = Files.readAllLines(this.csvVile);
        ArrayList<ZeitWert> result = new ArrayList<ZeitWert>();
        for (String zeile : zeilen) {
            result.add(this.parseZeile(zeile));
        }
        return result;
    }

    private ZeitWert parseZeile(String zeile) throws ParseException {
        String[] felder = zeile.split(";");
        if (felder.length < 3) {
            throw new ParseException("Zeile hat zu wenig Felder: '" + zeile + "'", 0);
        }
        String feldDatum = felder[0];
        String feldUhrzeit = felder[1];
        String feldWert = felder[2];
        ZonedDateTime zeit = ZonedDateTime.from(datumsformat.parse(feldDatum + " " + feldUhrzeit));
        double wert = l\u00fcckeRepr\u00e4sentation.equals(feldWert) ? Double.NaN : zahlenformat.parse(feldWert).doubleValue();
        return new ZeitWert(zeit, wert);
    }
}

