/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.repository.hydras;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import luwa.marlin.importer.hydras.dom\u00e4ne.HydrasMessstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.Messstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.Notiz;
import luwa.marlin.importer.hydras.dom\u00e4ne.Sensor;
import luwa.marlin.importer.hydras.dom\u00e4ne.Sensornummer;
import luwa.marlin.importer.hydras.dom\u00e4ne.Zeitzone;
import luwa.marlin.importer.hydras.repository.SqlHelpers;

public class HydrasMessstelleRepository {
    private final Connection connection;
    private final HydrasMessstelle messstelle;

    public HydrasMessstelleRepository(Connection connection, HydrasMessstelle messstelle) {
        this.connection = connection;
        this.messstelle = messstelle;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Sensor> sonden() {
        try {
            String sql = "SELECT * FROM ss_datei";
            try (PreparedStatement query = this.connection.prepareStatement("SELECT * FROM ss_datei");){
                ArrayList<Sensor> arrayList;
                block15: {
                    ResultSet rs = query.executeQuery();
                    try {
                        ArrayList<Sensor> result = new ArrayList<Sensor>();
                        while (rs.next()) {
                            Optional<Timestamp> datenVon = Optional.ofNullable(rs.getTimestamp("daten_von"));
                            Optional<Timestamp> datenBis = Optional.ofNullable(rs.getTimestamp("daten_bis"));
                            Optional<Timestamp> datenNeu = Optional.ofNullable(rs.getTimestamp("daten_neu"));
                            result.add(new Sensor(new Sensornummer(rs.getString("nr")), rs.getString("name"), datenVon.map(d -> ZonedDateTime.ofInstant(d.toInstant(), Zeitzone.zeitzoneMEZ)).orElse(null), datenBis.map(d -> ZonedDateTime.ofInstant(d.toInstant(), Zeitzone.zeitzoneMEZ)).orElse(null), datenNeu.map(d -> ZonedDateTime.ofInstant(d.toInstant(), Zeitzone.zeitzoneMEZ)).orElse(null)));
                        }
                        arrayList = result;
                        if (rs == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return arrayList;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Sensoren in Paradox-Datenbank f\u00fcr Messstelle " + this.messstelle.pkz() + " nicht laden (Exception: " + e.getMessage() + ")");
        }
    }

    public List<Notiz> infos(Messstelle zielMessstelle) {
        return this.infosAusTabelle("msinfo", Optional.empty(), zielMessstelle);
    }

    public List<Notiz> infosF\u00fcrSensor(Sensornummer sensornummer, Messstelle zielMessstelle) {
        return this.infosAusTabelle("info" + sensornummer.nummer(), Optional.of(sensornummer), zielMessstelle);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Notiz> infosAusTabelle(String tabellenName, Optional<Sensornummer> sensornummer, Messstelle zielMessstelle) {
        try {
            if (!SqlHelpers.istTabelleVorhanden(this.connection, tabellenName)) {
                return Collections.emptyList();
            }
            String sql = "SELECT * FROM " + tabellenName + " ORDER BY datetime";
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                ArrayList<Notiz> arrayList;
                block16: {
                    ResultSet rs = query.executeQuery();
                    try {
                        ArrayList<Notiz> result = new ArrayList<Notiz>();
                        while (rs.next()) {
                            result.add(new Notiz(zielMessstelle, ZonedDateTime.ofInstant(rs.getTimestamp("datetime").toInstant(), Zeitzone.zeitzoneMEZ), Optional.ofNullable(rs.getString("note")).orElse(""), sensornummer.isPresent() ? SqlHelpers.getOptionalDouble(rs, "value") : Optional.empty(), sensornummer));
                        }
                        arrayList = result;
                        if (rs == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return arrayList;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Infos aus Paradox-Datenbank-Tabelle '" + tabellenName + "' f\u00fcr Messstelle " + this.messstelle.pkz() + " nicht laden", e);
        }
    }
}

