/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.repository.hydras;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import luwa.marlin.importer.hydras.dom\u00e4ne.Betreiber;
import luwa.marlin.importer.hydras.dom\u00e4ne.Eigent\u00fcmer;
import luwa.marlin.importer.hydras.dom\u00e4ne.Gebiet;
import luwa.marlin.importer.hydras.dom\u00e4ne.HydrasMessstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.Messstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.MessstelleStammdaten;
import luwa.marlin.importer.hydras.dom\u00e4ne.StALU;
import luwa.marlin.importer.hydras.util.Logdatei;

public class HydrasArbeitsplatzRepository {
    private final Connection connection;
    private final StALU stalu;
    private final Optional<Logdatei> importLog;

    public HydrasArbeitsplatzRepository(Connection connection, StALU stalu, Optional<Logdatei> importLog) {
        this.connection = connection;
        this.stalu = stalu;
        this.importLog = importLog;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Gebiet> gebiete() {
        try {
            String sql = "SELECT * FROM gb_datei";
            try (PreparedStatement query = this.connection.prepareStatement("SELECT * FROM gb_datei");){
                ArrayList<Gebiet> arrayList;
                block15: {
                    ResultSet rs = query.executeQuery();
                    try {
                        ArrayList<Gebiet> result = new ArrayList<Gebiet>();
                        while (rs.next()) {
                            result.add(new Gebiet(rs.getLong("gb_nr"), rs.getString("gb_text"), Optional.ofNullable(rs.getString("gb_mdatei"))));
                        }
                        arrayList = result;
                        if (rs == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return arrayList;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Gebiete nicht aus Paradox-Datenbank laden", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<HydrasMessstelle> messstellen(Gebiet gebiet) {
        if (gebiet.tabelle().isEmpty()) {
            return this.stammdaten().stream().map(MessstelleStammdaten::messstelle).collect(Collectors.toList());
        }
        try {
            String sql = "SELECT * FROM " + gebiet.tabelle();
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                ArrayList<HydrasMessstelle> arrayList;
                block16: {
                    ResultSet rs = query.executeQuery();
                    try {
                        ArrayList<HydrasMessstelle> result = new ArrayList<HydrasMessstelle>();
                        while (rs.next()) {
                            String gbmMsnr = rs.getString("gbm_msnr");
                            if (gbmMsnr == null || gbmMsnr.length() < 3) continue;
                            String pkz = HydrasArbeitsplatzRepository.insertPeriodBeforeLastTwo(gbmMsnr);
                            result.add(new HydrasMessstelle(pkz));
                        }
                        arrayList = result;
                        if (rs == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return arrayList;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Messstellen f\u00fcr Gebiet '" + gebiet.name() + "' nicht aus Paradox-Datenbank laden", e);
        }
    }

    public static String insertPeriodBeforeLastTwo(String str) {
        if (str == null || str.length() < 3) {
            throw new IllegalArgumentException("String must have at least 3 characters");
        }
        return str.substring(0, str.length() - 2) + "." + str.substring(str.length() - 2);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<MessstelleStammdaten> stammdaten(Messstelle messstelle) {
        try {
            String sql = "SELECT * FROM ms_datei WHERE nr=?";
            try (PreparedStatement query = this.connection.prepareStatement("SELECT * FROM ms_datei WHERE nr=?");){
                Optional<MessstelleStammdaten> optional;
                block18: {
                    ResultSet rs;
                    block16: {
                        Optional<MessstelleStammdaten> optional2;
                        block17: {
                            query.setString(1, String.format("%010d", messstelle.nummer()));
                            rs = query.executeQuery();
                            try {
                                if (!rs.next()) break block16;
                                optional2 = Optional.of(this.stammdatenAus(rs));
                                if (rs == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        return optional2;
                    }
                    optional = Optional.empty();
                    if (rs == null) break block18;
                    rs.close();
                }
                return optional;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Stammdaten f\u00fcr Messstelle '" + messstelle.nummer() + "' nicht aus Paradox-Datenbank laden", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<MessstelleStammdaten> stammdaten() {
        try {
            String sql = "SELECT * FROM ms_datei";
            try (PreparedStatement query = this.connection.prepareStatement("SELECT * FROM ms_datei");){
                ArrayList<MessstelleStammdaten> arrayList;
                block17: {
                    ResultSet rs = query.executeQuery();
                    try {
                        ArrayList<MessstelleStammdaten> result = new ArrayList<MessstelleStammdaten>();
                        while (rs.next()) {
                            try {
                                result.add(this.stammdatenAus(rs));
                            }
                            catch (NumberFormatException e) {
                                this.importLog.ifPresent(logdatei -> logdatei.logge("! Ung\u00fcltige Messstellennummer. " + e.getMessage()));
                            }
                        }
                        arrayList = result;
                        if (rs == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return arrayList;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Stammdaten nicht aus Paradox-Datenbank laden", e);
        }
    }

    private MessstelleStammdaten stammdatenAus(ResultSet rs) throws SQLException {
        Eigent\u00fcmer eigent\u00fcmer = this.stalu.eigent\u00fcmer();
        Betreiber betreiber = new Betreiber(eigent\u00fcmer.nummer(), eigent\u00fcmer);
        String pkz = HydrasArbeitsplatzRepository.insertPeriodBeforeLastTwo(rs.getString("nr"));
        return new MessstelleStammdaten(new HydrasMessstelle(pkz), rs.getString("name"), Optional.ofNullable(rs.getString("ort")), betreiber, Optional.ofNullable(rs.getString("notiz")));
    }
}

