/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.repository.hydras;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import luwa.marlin.importer.hydras.dom\u00e4ne.AbflusskurveEta;
import luwa.marlin.importer.hydras.dom\u00e4ne.HydrasMessstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.Kurveng\u00fcltigkeit;
import luwa.marlin.importer.hydras.dom\u00e4ne.Messstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.WQPaar;
import luwa.marlin.importer.hydras.repository.SqlHelpers;

public class HydrasAbflusskurvenRepository {
    private final Connection connection;
    private final HydrasMessstelle messstelle;

    public HydrasAbflusskurvenRepository(Connection messstelleDatenbankConnection, HydrasMessstelle messstelle) {
        this.connection = messstelleDatenbankConnection;
        this.messstelle = messstelle;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Kurveng\u00fcltigkeit> g\u00fcltigkeiten() {
        try {
            String tabellenName = "setatv0";
            if (!SqlHelpers.istTabelleVorhanden(this.connection, "setatv0")) {
                return Collections.emptyList();
            }
            String sql = "SELECT * FROM setatv0 ORDER BY vdate desc";
            try (PreparedStatement query = this.connection.prepareStatement("SELECT * FROM setatv0 ORDER BY vdate desc");){
                ArrayList<Kurveng\u00fcltigkeit> arrayList;
                block16: {
                    ResultSet rs = query.executeQuery();
                    try {
                        ArrayList<Kurveng\u00fcltigkeit> g\u00fcltigkeiten = new ArrayList<Kurveng\u00fcltigkeit>();
                        Optional<ZonedDateTime> letztesG\u00fcltigVon = Optional.empty();
                        while (rs.next()) {
                            long nummer = rs.getLong("index");
                            ZonedDateTime g\u00fcltigVon = SqlHelpers.getDateTime(rs, "vdate");
                            g\u00fcltigkeiten.add(new Kurveng\u00fcltigkeit(nummer, g\u00fcltigVon, letztesG\u00fcltigVon));
                            letztesG\u00fcltigVon = Optional.of(g\u00fcltigVon);
                        }
                        arrayList = g\u00fcltigkeiten;
                        if (rs == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return arrayList;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Keine Kurveng\u00fcltigkeiten f\u00fcr Messstelle " + this.messstelle.pkz() + " in Paradox-Datenbank: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public AbflusskurveEta etaKurven(long virtuelleSondeId, Messstelle zielMessstelle) {
        try {
            String tabellenname = String.format("setat%03d", virtuelleSondeId);
            String sql = "SELECT * FROM " + tabellenname;
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                AbflusskurveEta abflusskurveEta;
                block15: {
                    ResultSet rs = query.executeQuery();
                    try {
                        ArrayList<WQPaar> tabelleMin = new ArrayList<WQPaar>();
                        ArrayList<WQPaar> tabelleMax = new ArrayList<WQPaar>();
                        while (rs.next()) {
                            tabelleMin.add(new WQPaar(rs.getInt("wlevel"), rs.getDouble("qmin")));
                            tabelleMax.add(new WQPaar(rs.getInt("wlevel"), rs.getDouble("qmax")));
                        }
                        String name = String.valueOf(virtuelleSondeId);
                        abflusskurveEta = new AbflusskurveEta(zielMessstelle, name, tabelleMin, tabelleMax);
                        if (rs == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return abflusskurveEta;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Abflusskurve nicht aus Paradox-Datenbank f\u00fcr virtuelle Sonde " + virtuelleSondeId + " von Messstelle " + this.messstelle.pkz() + " laden", e);
        }
    }
}

