/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import luwa.marlin.importer.hydras.dom\u00e4ne.Zeitzone;

public final class SqlHelpers {
    private static Optional<ZonedDateTime> getOptionalDateTime(ResultSet rs, String columnLabel) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnLabel, SqlHelpers.calendar());
        if (rs.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(timestamp.toInstant().atZone(Zeitzone.zeitzoneMEZ));
    }

    public static ZonedDateTime getDateTime(ResultSet rs, String columnLabel) throws SQLException {
        return rs.getTimestamp(columnLabel, SqlHelpers.calendar()).toInstant().atZone(Zeitzone.zeitzoneMEZ);
    }

    public static void setDateTime(PreparedStatement statement, int parameterIndex, ZonedDateTime dateTime) throws SQLException {
        statement.setTimestamp(parameterIndex, SqlHelpers.timestamp(dateTime), SqlHelpers.calendar());
    }

    public static void setOptionalDateTime(PreparedStatement statement, int parameterIndex, Optional<ZonedDateTime> dateTime) throws SQLException {
        if (dateTime.isEmpty()) {
            statement.setTimestamp(parameterIndex, null, SqlHelpers.calendar());
            return;
        }
        statement.setTimestamp(parameterIndex, SqlHelpers.timestamp(dateTime.get()), SqlHelpers.calendar());
    }

    public static Optional<Double> getOptionalDouble(ResultSet rs, String columnLabel) throws SQLException {
        double value = rs.getDouble(columnLabel);
        if (rs.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static void setOptionalDouble(PreparedStatement statement, int parameterIndex, Optional<Double> value) throws SQLException {
        if (value.isEmpty()) {
            statement.setNull(parameterIndex, 8);
            return;
        }
        statement.setDouble(parameterIndex, value.get());
    }

    public static void setDouble(PreparedStatement statement, int parameterIndex, double value) throws SQLException {
        if (Double.isNaN(value)) {
            statement.setNull(parameterIndex, 8);
            return;
        }
        statement.setDouble(parameterIndex, value);
    }

    private static Calendar calendar() {
        return Calendar.getInstance(Zeitzone.calendarZeitzoneMEZ);
    }

    private static Timestamp timestamp(ZonedDateTime dateTime) {
        if (null == dateTime) {
            return null;
        }
        return Timestamp.from(dateTime.toInstant());
    }

    public static boolean istTabelleVorhanden(Connection connection, String tabellenName) throws SQLException {
        return SqlHelpers.alleTabellenNamen(connection).stream().anyMatch(tn -> tn.equalsIgnoreCase(tabellenName));
    }

    private static List<String> alleTabellenNamen(Connection connection) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        try (ResultSet rs = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), "", null);){
            while (rs.next()) {
                String catalog = rs.getString(1);
                String schema = rs.getString(2);
                String tableName = rs.getString(3);
                tables.add(tableName);
            }
        }
        return tables;
    }
}

