/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import luwa.marlin.importer.hydras.dom\u00e4ne.HydrasMessstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.Messstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.Sensornummer;
import luwa.marlin.importer.hydras.dom\u00e4ne.StALU;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.ZielDefinition;

public class SensorMatrix {
    private final Map<Schl\u00fcssel, List<ZielDefinition>> lookup;
    private final LocalDateTime g\u00fcltigAb;

    public SensorMatrix(Map<Schl\u00fcssel, List<ZielDefinition>> lookup, LocalDateTime g\u00fcltigAb) {
        this.lookup = lookup;
        this.g\u00fcltigAb = g\u00fcltigAb;
    }

    public LocalDateTime g\u00fcltigAb() {
        return this.g\u00fcltigAb;
    }

    public List<ZielDefinition> ziele(StALU stalu, HydrasMessstelle messstelle, Sensornummer sensor) {
        return this.ziele(new Schl\u00fcssel(stalu, messstelle, sensor));
    }

    private List<ZielDefinition> ziele(Schl\u00fcssel schl\u00fcssel) {
        return this.lookup.getOrDefault(schl\u00fcssel, Collections.emptyList());
    }

    public boolean enth\u00e4ltImportZielF\u00fcr(StALU stalu, Messstelle messstelle) {
        return this.lookup.keySet().stream().anyMatch(key -> key.stalu == stalu && key.messstelle.equals(messstelle));
    }

    public boolean enth\u00e4ltImportZielF\u00fcr(StALU stalu, HydrasMessstelle messstelle) {
        return this.lookup.keySet().stream().anyMatch(key -> key.stalu == stalu && key.messstelle.equals(messstelle));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sensor-Matrix-Eintr\u00e4ge: ").append(this.lookup.size()).append("\n");
        for (Map.Entry<Schl\u00fcssel, List<ZielDefinition>> entry : this.lookup.entrySet()) {
            sb.append(entry.getKey());
            sb.append(" -> ");
            sb.append(entry.getValue());
            sb.append('\n');
        }
        return sb.toString();
    }

    public static class Schl\u00fcssel {
        private final StALU stalu;
        private final HydrasMessstelle messstelle;
        private final Sensornummer sensor;

        public Schl\u00fcssel(StALU stalu, HydrasMessstelle messstelle, Sensornummer sonde) {
            this.stalu = stalu;
            this.messstelle = messstelle;
            this.sensor = sonde;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Schl\u00fcssel that = (Schl\u00fcssel)o;
            return this.stalu == that.stalu && Objects.equals(this.messstelle, that.messstelle) && Objects.equals(this.sensor, that.sensor);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.stalu, this.messstelle, this.sensor});
        }

        public String toString() {
            return "(StALU " + this.stalu.k\u00fcrzel() + ", PKZ " + this.messstelle.pkz() + ", Sensor-Nr " + this.sensor.nummer() + ")";
        }
    }
}

