/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import luwa.marlin.importer.hydras.dom\u00e4ne.HydrasMessstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.Messstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.Sensornummer;
import luwa.marlin.importer.hydras.dom\u00e4ne.StALU;
import luwa.marlin.importer.hydras.dom\u00e4ne.ZuordnungPKZDoppelt;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.ParameterSpalte;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.SensorMatrix;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.ZellWert;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.ZielDefinition;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.Zieltabelle;
import luwa.marlin.importer.hydras.util.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;

public class ExcelSensorMatrixLeser {
    private final Logger logger;
    private static final int StartZeile = 3;
    private static final int Spalte_StALU = CellReference.convertColStringToIndex("A");
    private static final int Spalte_PKZ = CellReference.convertColStringToIndex("B");
    private static final int Spalte_PKZ_Ersatz = CellReference.convertColStringToIndex("C");
    private static final int Spalte_Zuordnung_PKZ_doppelt = CellReference.convertColStringToIndex("D");
    private static final int Spalte_SensorNr = CellReference.convertColStringToIndex("E");
    private static final int Spalte_Name = CellReference.convertColStringToIndex("F");
    private static final int Spalte_Einheit = CellReference.convertColStringToIndex("G");
    private static final int Spalte_Skalierungsfaktor = CellReference.convertColStringToIndex("AA");

    public ExcelSensorMatrixLeser(Logger logger) {
        this.logger = logger;
    }

    public SensorMatrix leseSensorMatrix(File excelDatei, LocalDateTime g\u00fcltigAb) throws IOException {
        HashMap<SensorMatrix.Schl\u00fcssel, List<ZielDefinition>> lookup = new HashMap<SensorMatrix.Schl\u00fcssel, List<ZielDefinition>>();
        try (Workbook workbook = WorkbookFactory.create(excelDatei);){
            int anzahlArbeitsbl\u00e4tter = workbook.getNumberOfSheets();
            for (int arbeitsblattIndex = 0; arbeitsblattIndex < anzahlArbeitsbl\u00e4tter; ++arbeitsblattIndex) {
                Sheet arbeitsblatt = workbook.getSheetAt(arbeitsblattIndex);
                this.verarbeiteArbeitsblatt(excelDatei, arbeitsblatt, lookup);
            }
            SensorMatrix sensorMatrix = new SensorMatrix(lookup, g\u00fcltigAb);
            return sensorMatrix;
        }
    }

    private void verarbeiteArbeitsblatt(File excelDatei, Sheet arbeitsblatt, Map<SensorMatrix.Schl\u00fcssel, List<ZielDefinition>> lookup) {
        this.logger.logge("--- Arbeitsblatt '" + arbeitsblatt.getSheetName() + "' ---");
        int zeilenIndex = 3;
        while (true) {
            int zeilennummer = ++zeilenIndex;
            Row zeile = arbeitsblatt.getRow(zeilenIndex);
            if (null == zeile) break;
            Optional<Cell> staluZelle = Optional.ofNullable(zeile.getCell(Spalte_StALU));
            if (staluZelle.isEmpty()) {
                this.logger.logge("Letzte Zeile (" + zeilennummer + ") erreicht");
                break;
            }
            String staluZellinhalt = this.zelleStringInhalt(staluZelle.get());
            String pkzZellinhalt = this.zelleStringInhalt(zeile.getCell(Spalte_PKZ));
            String pkzErsatzZellinhalt = this.zelleStringInhalt(zeile.getCell(Spalte_PKZ_Ersatz));
            String zuordnungPKZDoppeltZellinhalt = this.zelleStringInhalt(zeile.getCell(Spalte_Zuordnung_PKZ_doppelt));
            String sensorNrZellinhalt = this.sensorNrAusZelle(zeile.getCell(Spalte_SensorNr));
            String nameZellinhalt = this.zelleStringInhalt(zeile.getCell(Spalte_Name));
            String einheitZellinhalt = this.zelleStringInhalt(zeile.getCell(Spalte_Einheit));
            double skalierungsfaktor = this.zelleDoubleInhalt(zeile.getCell(Spalte_Skalierungsfaktor));
            if (!zuordnungPKZDoppeltZellinhalt.isEmpty() && !zuordnungPKZDoppeltZellinhalt.equals(staluZellinhalt)) continue;
            try {
                StALU stalu = StALU.ausK\u00fcrzel(staluZellinhalt).orElseThrow(() -> new ParseException("Unbekanntes StALU: " + staluZellinhalt, zeilennummer));
                HydrasMessstelle hydrasMessstelle = new HydrasMessstelle(pkzZellinhalt);
                Optional<Messstelle> messstelleOptional = Messstelle.ausPKZ(pkzZellinhalt);
                Optional<Messstelle> messstelleErsatzOptional = Messstelle.ausPKZ(pkzErsatzZellinhalt);
                if (messstelleOptional.isEmpty() && messstelleErsatzOptional.isEmpty()) {
                    this.logger.logge("Zeile " + zeilennummer + ": Messstelle mit PKZ '" + pkzZellinhalt + "' wird ignoriert, da PKZ-Format nicht unterst\u00fctzt und kein PKZ-Ersatz angegeben");
                    continue;
                }
                Messstelle messstelle = messstelleErsatzOptional.orElseGet(() -> (Messstelle)messstelleOptional.get());
                ZuordnungPKZDoppelt zuordnungPKZDoppelt = ZuordnungPKZDoppelt.ausZellinhalt(zuordnungPKZDoppeltZellinhalt);
                Sensornummer sensorNummer = new Sensornummer(sensorNrZellinhalt);
                SensorMatrix.Schl\u00fcssel matrixSchl\u00fcssel = new SensorMatrix.Schl\u00fcssel(stalu, hydrasMessstelle, sensorNummer);
                ArrayList<ZielDefinition> ziele = new ArrayList<ZielDefinition>();
                for (ParameterSpalte spalte : ParameterSpalte.values()) {
                    Optional<Zieltabelle> zieltabelle;
                    ZellWert zellWert = this.zellWert(zeile, spalte);
                    if (zellWert == ZellWert.nichtGesetzt || !(zieltabelle = Optional.ofNullable(spalte.zieltabelle(zellWert))).isPresent()) continue;
                    ziele.add(new ZielDefinition(messstelle, zellWert, spalte.zieltabelle(zellWert), skalierungsfaktor));
                }
                if (zuordnungPKZDoppelt == ZuordnungPKZDoppelt.keinImportAnderesStALU || ziele.isEmpty()) continue;
                lookup.put(matrixSchl\u00fcssel, ziele);
            }
            catch (ParseException e) {
                this.logger.logge("Konnte Zeile " + zeilennummer + " von Matrixdatei " + excelDatei.getName() + " aufgrund eines Formatfehlers nicht erfolgreich auswerten: " + e.getMessage());
            }
        }
    }

    private String sensorNrAusZelle(Cell zelle) {
        if (zelle == null) {
            return "";
        }
        if (zelle.getCellType() == CellType.NUMERIC) {
            return String.valueOf(String.format("%04d", (int)zelle.getNumericCellValue()));
        }
        return this.zelleStringInhalt(zelle);
    }

    private ZellWert zellWert(Row zeile, ParameterSpalte spalte) {
        Cell zelle = zeile.getCell(spalte.spaltenIndex());
        String stringInhalt = this.zelleStringInhalt(zelle);
        return ZellWert.f\u00fcrKey(stringInhalt);
    }

    private String zelleStringInhalt(Cell zelle) {
        if (null == zelle || zelle.getCellType() != CellType.STRING) {
            return "";
        }
        return zelle.getStringCellValue().trim();
    }

    private int zelleIntegerInhalt(Cell zelle) {
        if (null == zelle || zelle.getCellType() != CellType.NUMERIC) {
            return 1;
        }
        return (int)zelle.getNumericCellValue();
    }

    private double zelleDoubleInhalt(Cell zelle) {
        if (null == zelle || zelle.getCellType() != CellType.NUMERIC) {
            return 1.0;
        }
        return zelle.getNumericCellValue();
    }
}

