/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras.dom\u00e4ne;

import java.util.Stack;

public class AbflusskurveFormel {
    private final String formel;

    public AbflusskurveFormel(String formel) {
        this.formel = formel;
    }

    public double berechne(double ... xs) {
        String formula = this.formel.replace(",", ".");
        Stack<Double> operands = new Stack<Double>();
        Stack<Character> operators = new Stack<Character>();
        for (int i = 0; i < formula.length(); ++i) {
            char c = formula.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (Character.isDigit(c) || c == '.') {
                Object number = "";
                while (i < formula.length() && (Character.isDigit(formula.charAt(i)) || formula.charAt(i) == '.')) {
                    number = (String)number + formula.charAt(i++);
                }
                --i;
                operands.push(Double.parseDouble((String)number));
                continue;
            }
            if (c == 'X') {
                Object variable = "";
                while (i < formula.length() && formula.charAt(i) != '+' && formula.charAt(i) != '-' && formula.charAt(i) != '*' && formula.charAt(i) != '/' && formula.charAt(i) != '^' && formula.charAt(i) != ')' && !Character.isWhitespace(formula.charAt(i))) {
                    variable = (String)variable + formula.charAt(i++);
                }
                --i;
                if (((String)variable).startsWith("X")) {
                    try {
                        int variableNumber = Integer.parseInt(((String)variable).substring(1));
                        int variableIndex = variableNumber - 1;
                        if (variableIndex >= xs.length) {
                            throw new IllegalArgumentException("Nicht unterst\u00fctzte Variable: " + (String)variable);
                        }
                        operands.push(xs[variableIndex]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Nicht unterst\u00fctzte Variable: " + (String)variable);
                    }
                }
                throw new IllegalArgumentException("Nicht unterst\u00fctzte Variable: " + (String)variable);
            }
            if (c == '(') {
                operators.push(Character.valueOf(c));
                continue;
            }
            if (c == ')') {
                while (((Character)operators.peek()).charValue() != '(') {
                    operands.push(AbflusskurveFormel.applyOperator(((Character)operators.pop()).charValue(), (Double)operands.pop(), (Double)operands.pop()));
                }
                operators.pop();
                continue;
            }
            if (c == '+' || c == '-' || c == '*' || c == '/' || c == '^') {
                while (!operators.isEmpty() && AbflusskurveFormel.precedence(c) <= AbflusskurveFormel.precedence(((Character)operators.peek()).charValue())) {
                    operands.push(AbflusskurveFormel.applyOperator(((Character)operators.pop()).charValue(), (Double)operands.pop(), (Double)operands.pop()));
                }
                operators.push(Character.valueOf(c));
                continue;
            }
            throw new IllegalArgumentException("Ung\u00fcltiges Zeichen: " + c);
        }
        while (!operators.isEmpty()) {
            operands.push(AbflusskurveFormel.applyOperator(((Character)operators.pop()).charValue(), (Double)operands.pop(), (Double)operands.pop()));
        }
        return (Double)operands.pop();
    }

    private static int precedence(char op) {
        if (op == '+' || op == '-') {
            return 1;
        }
        if (op == '*' || op == '/') {
            return 2;
        }
        if (op == '^') {
            return 3;
        }
        return 0;
    }

    private static double applyOperator(char op, double b, double a) {
        switch (op) {
            case '+': {
                return a + b;
            }
            case '-': {
                return a - b;
            }
            case '*': {
                return a * b;
            }
            case '/': {
                return a / b;
            }
            case '^': {
                return Math.pow(a, b);
            }
        }
        throw new IllegalArgumentException("Ung\u00fcltiger Operator: " + op);
    }
}

