/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.hydras;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import luwa.marlin.importer.hydras.db.Datenbanken;
import luwa.marlin.importer.hydras.db.HydrasArbeitsplatz;
import luwa.marlin.importer.hydras.dom\u00e4ne.AbflusskurveEta;
import luwa.marlin.importer.hydras.dom\u00e4ne.Betreiber;
import luwa.marlin.importer.hydras.dom\u00e4ne.Eigent\u00fcmer;
import luwa.marlin.importer.hydras.dom\u00e4ne.Gebiet;
import luwa.marlin.importer.hydras.dom\u00e4ne.HydrasMessstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.Kurveng\u00fcltigkeit;
import luwa.marlin.importer.hydras.dom\u00e4ne.Messstelle;
import luwa.marlin.importer.hydras.dom\u00e4ne.MessstelleStammdaten;
import luwa.marlin.importer.hydras.dom\u00e4ne.Notiz;
import luwa.marlin.importer.hydras.dom\u00e4ne.Parameter;
import luwa.marlin.importer.hydras.dom\u00e4ne.Sensor;
import luwa.marlin.importer.hydras.dom\u00e4ne.StALU;
import luwa.marlin.importer.hydras.dom\u00e4ne.WeitereZeitreihe;
import luwa.marlin.importer.hydras.dom\u00e4ne.ZeitWert;
import luwa.marlin.importer.hydras.dom\u00e4ne.Zeitreihe;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.SensorMatrix;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.ZellWert;
import luwa.marlin.importer.hydras.dom\u00e4ne.sensormatrix.ZielDefinition;
import luwa.marlin.importer.hydras.repository.hydras.HydrasAbflusskurvenRepository;
import luwa.marlin.importer.hydras.repository.hydras.HydrasArbeitsplatzRepository;
import luwa.marlin.importer.hydras.repository.hydras.HydrasMessstelleRepository;
import luwa.marlin.importer.hydras.repository.hydras.HydrasZeitreihenRepository;
import luwa.marlin.importer.hydras.repository.pegeldaten.AbflusskurvenRepository;
import luwa.marlin.importer.hydras.repository.pegeldaten.MessstellenRepository;
import luwa.marlin.importer.hydras.repository.pegeldaten.ZeitreihenRepository;
import luwa.marlin.importer.hydras.repository.sensormatrix.SensorMatrixRepository;
import luwa.marlin.importer.hydras.util.Logdatei;
import luwa.marlin.importer.hydras.util.Umgebungsvariable;
import org.apache.poi.hssf.usermodel.HSSFWorkbookFactory;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbookFactory;

public class Main {
    private static final Path hydrasArbeitsplatzBasisVerzeichnis = Path.of(Umgebungsvariable.mitFallback("MARLIN_HYDRAS_ARBEITSPLATZ_VERZEICHNIS", ""), new String[0]);
    private static final Path zeitreihenDatenRohBasisVerzeichnis = Path.of(Umgebungsvariable.mitFallback("MARLIN_HYDRAS_ZEITREIHEN_ROH_VERZEICHNIS", ""), new String[0]);
    private static final Path zeitreihenDatenEditiertBasisVerzeichnis = Path.of(Umgebungsvariable.mitFallback("MARLIN_HYDRAS_ZEITREIHEN_EDITIERT_VERZEICHNIS", ""), new String[0]);
    private static final Path sensorMatrixVerzeichnis = Path.of(Umgebungsvariable.mitFallback("MARLIN_HYDRAS_SENSOR_MATRIX_VERZEICHNIS", ""), new String[0]);
    private static final DateTimeFormatter datumsformat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter datumUhrzeitFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static void main(String[] args) throws Exception {
        WorkbookFactory.addProvider(new HSSFWorkbookFactory());
        WorkbookFactory.addProvider(new XSSFWorkbookFactory());
        List<String> arguments = Arrays.asList(args);
        boolean cleanFlagGesetzt = arguments.contains("--clean");
        boolean matrixDemoFlagGesetzt = arguments.contains("--matrix-demo");
        LocalDateTime importDatum = LocalDateTime.now();
        try (Logdatei importLog = new Logdatei("Importiert " + datumsformat.format(importDatum) + ".log");){
            importLog.logge("Beginn des Imports: " + datumUhrzeitFormat.format(importDatum));
            importLog.logge("Hydras-Arbeitsplatz-Basis-Verzeichnis       : " + hydrasArbeitsplatzBasisVerzeichnis);
            importLog.logge("Zeitreihendaten-Basis-Verzeichnis (roh)     : " + zeitreihenDatenRohBasisVerzeichnis);
            importLog.logge("Zeitreihendaten-Basis-Verzeichnis (editiert): " + zeitreihenDatenEditiertBasisVerzeichnis);
            importLog.logge("Sensor-Matrix-Verzeichnis                   : " + sensorMatrixVerzeichnis);
            LocalDateTime jetzt = LocalDateTime.now();
            Optional<SensorMatrix> sensorMatrix = new SensorMatrixRepository(sensorMatrixVerzeichnis, importLog).zuZeitpunkt(jetzt);
            if (sensorMatrix.isEmpty()) {
                importLog.logge("Keine g\u00fcltige Sensor-Matrix f\u00fcr den aktuellen Zeitpunkt (" + jetzt + ") gefunden.");
                return;
            }
            importLog.logge("Sensor-Matrix g\u00fcltig ab: " + sensorMatrix.get().g\u00fcltigAb());
            if (matrixDemoFlagGesetzt) {
                importLog.logge(sensorMatrix.get().toString());
                return;
            }
            try (Connection pegeldatenConnection = Datenbanken.pegeldatenDataSource().getConnection();
                 Connection ohydConnection = Datenbanken.ohydDataSource().getConnection();){
                MessstellenRepository ohydMessstellenRepository = new MessstellenRepository(ohydConnection);
                ZeitreihenRepository zeitreihenRepository = new ZeitreihenRepository(pegeldatenConnection);
                AbflusskurvenRepository abflusskurvenRepository = new AbflusskurvenRepository(pegeldatenConnection);
                if (cleanFlagGesetzt) {
                    importLog.logge("Existierende Import-Daten werden gel\u00f6scht (--clean Flag gesetzt)");
                    Main.l\u00f6scheExistierendeDaten(importLog, ohydMessstellenRepository, abflusskurvenRepository, zeitreihenRepository);
                }
                HashSet<HydrasMessstelle> importierteMessstellen = new HashSet<HydrasMessstelle>();
                for (StALU stalu : StALU.values()) {
                    importLog.logge("Beginn des Imports f\u00fcr StALU " + stalu.k\u00fcrzel());
                    for (String arbeitsplatzVerzeichnisName : stalu.hydrasDBDirectoryNames()) {
                        importLog.logge("Beginn des Imports f\u00fcr Arbeitsplatz " + arbeitsplatzVerzeichnisName);
                        HydrasArbeitsplatz hydrasArbeitsplatz = new HydrasArbeitsplatz(hydrasArbeitsplatzBasisVerzeichnis.resolve(arbeitsplatzVerzeichnisName));
                        importLog.logge("StALU-Hydras-Arbeitsplatz-Verzeichnis       : " + hydrasArbeitsplatz.verzeichnis());
                        Path zeitreihenDatenVerzeichnisRoh = zeitreihenDatenRohBasisVerzeichnis.resolve(arbeitsplatzVerzeichnisName);
                        importLog.logge("StALU-Zeitreihendaten-Verzeichnis (roh)     : " + zeitreihenDatenVerzeichnisRoh);
                        Path zeitreihenDatenVerzeichnisEditiert = zeitreihenDatenEditiertBasisVerzeichnis.resolve(arbeitsplatzVerzeichnisName);
                        importLog.logge("StALU-Zeitreihendaten-Verzeichnis (editiert): " + zeitreihenDatenVerzeichnisEditiert);
                        if (!Files.exists(hydrasArbeitsplatz.verzeichnis(), new LinkOption[0])) {
                            importLog.logge("! StALU-Hydras-Arbeitsplatz-Verzeichnis existiert nicht. Arbeitsplatz wird nicht importiert.");
                            continue;
                        }
                        try {
                            Connection arbeitsplatzConnection = Datenbanken.arbeitsplatzConnection(hydrasArbeitsplatz);
                            try {
                                HydrasArbeitsplatzRepository hydrasArbeitsplatzRepository = new HydrasArbeitsplatzRepository(arbeitsplatzConnection, stalu, Optional.of(importLog));
                                Main.importiereStALU(stalu, importLog, importierteMessstellen, hydrasArbeitsplatz, hydrasArbeitsplatzRepository, ohydMessstellenRepository, zeitreihenRepository, abflusskurvenRepository, sensorMatrix.get(), zeitreihenDatenVerzeichnisRoh, zeitreihenDatenVerzeichnisEditiert);
                            }
                            finally {
                                if (arbeitsplatzConnection == null) continue;
                                arbeitsplatzConnection.close();
                            }
                        }
                        catch (Exception e) {
                            importLog.logge("! " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
                importLog.logge("Ende des Imports: " + datumUhrzeitFormat.format(LocalDateTime.now()));
                importLog.logge("Fertig.");
            }
        }
    }

    private static void legeEigent\u00fcmerUndBetreiberAn(Logdatei importLog, MessstellenRepository ohydMessstellenRepository) {
        List<Eigent\u00fcmer> eigent\u00fcmer = Arrays.stream(StALU.values()).map(StALU::eigent\u00fcmer).collect(Collectors.toList());
        ohydMessstellenRepository.legeEigent\u00fcmerAn(eigent\u00fcmer);
        List<Betreiber> betreiber = Arrays.stream(StALU.values()).map(stalu -> new Betreiber(stalu.eigent\u00fcmer().nummer(), stalu.eigent\u00fcmer())).collect(Collectors.toList());
        ohydMessstellenRepository.legeBetreiberAn(betreiber);
    }

    private static void importiereStALU(StALU stalu, Logdatei importLog, Set<HydrasMessstelle> importierteMessstellen, HydrasArbeitsplatz hydrasArbeitsplatz, HydrasArbeitsplatzRepository hydrasArbeitsplatzRepository, MessstellenRepository ohydMessstellenRepository, ZeitreihenRepository zeitreihenRepository, AbflusskurvenRepository abflusskurvenRepository, SensorMatrix sensorMatrix, Path zeitreihenDatenVerzeichnisRoh, Path zeitreihenDatenVerzeichnisEditiert) {
        List<Gebiet> gebiete = hydrasArbeitsplatzRepository.gebiete();
        importLog.logge("Es gibt " + gebiete.size() + " Gebiete im zu importierenden Hydras-Arbeitsplatz.");
        List<MessstelleStammdaten> messstellenStammdaten = hydrasArbeitsplatzRepository.stammdaten();
        importLog.logge("Es gibt " + messstellenStammdaten.size() + " Messstellen im zu importierenden Hydras-Arbeitsplatz.");
        List<MessstelleStammdaten> doppelteMessstellen = Main.findeDuplikate(messstellenStammdaten);
        if (!doppelteMessstellen.isEmpty()) {
            importLog.logge("Doppelte Messstellen: " + doppelteMessstellen.stream().map(mst -> mst.messstelle().pkz()).collect(Collectors.joining(", ")));
        }
        int anzahlMessstellen = messstellenStammdaten.size();
        ArrayList<MessstelleStammdaten> anzulegendeMessstellenStammdaten = new ArrayList<MessstelleStammdaten>();
        for (MessstelleStammdaten stammdaten : messstellenStammdaten) {
            HydrasMessstelle messstelle = stammdaten.messstelle();
            if (importierteMessstellen.contains(messstelle)) {
                importLog.logge("! Messstelle " + messstelle.pkz() + " wurde schon zuvor bei anderem Hydras-Arbeitsplatz importiert, und wird daher hier ignoriert");
                continue;
            }
            if (sensorMatrix.enth\u00e4ltImportZielF\u00fcr(stalu, messstelle)) {
                anzulegendeMessstellenStammdaten.add(stammdaten);
                continue;
            }
            importLog.logge("! Messstelle " + messstelle.pkz() + " hat kein Import-Ziel f\u00fcr StALU " + stalu.k\u00fcrzel() + " und wird f\u00fcr dieses StALU nicht importiert");
        }
        int i = 1;
        for (MessstelleStammdaten stammdaten : messstellenStammdaten) {
            HydrasMessstelle hydrasMessstelle;
            block21: {
                hydrasMessstelle = stammdaten.messstelle();
                importLog.logge("----- Messstelle: " + hydrasMessstelle.pkz() + ", StALU " + stalu.k\u00fcrzel() + " (" + i + " von " + anzahlMessstellen + "), Import-Zeitpunkt: " + datumUhrzeitFormat.format(LocalDateTime.now()) + " -----");
                Optional<Path> sensorFormelDateiPfad = Main.benenneSSDateiXMLUmFallsVorhanden(hydrasArbeitsplatz, hydrasMessstelle, importLog);
                if (sensorFormelDateiPfad.isPresent()) {
                    Main.importiereSensorFormelnAus(sensorFormelDateiPfad);
                }
                try (Connection messstelleDatenbankConnection = Datenbanken.hydrasMessstelle(hydrasArbeitsplatz, hydrasMessstelle);){
                    HydrasMessstelleRepository hydrasMessstelleRepository = new HydrasMessstelleRepository(messstelleDatenbankConnection, hydrasMessstelle);
                    try {
                        List<Sensor> sonden = hydrasMessstelleRepository.sonden();
                        importLog.logge("* Importiere Zeitreihen ...");
                        Main.importiereZeitreihen(stalu, hydrasMessstelle, sonden, sensorMatrix, zeitreihenDatenVerzeichnisRoh, zeitreihenDatenVerzeichnisEditiert, hydrasMessstelleRepository, zeitreihenRepository, importLog);
                    }
                    catch (Exception e) {
                        importLog.logge("! " + e.getMessage());
                    }
                    Optional<Messstelle> messstelle = Messstelle.ausPKZ(hydrasMessstelle.pkz());
                    if (!messstelle.isPresent()) break block21;
                    try {
                        List<Notiz> notizen = hydrasMessstelleRepository.infos(messstelle.get());
                        importLog.logge("* Importiere allgemeine Notizen der Messstelle ...");
                        zeitreihenRepository.f\u00fcgeNotizenEin(notizen);
                        importLog.logge("    Notizen importiert: " + notizen.size() + " Werte");
                    }
                    catch (Exception e) {
                        importLog.logge("! " + e.getMessage());
                    }
                    try {
                        importLog.logge("* Importiere Abflusskurven und G\u00fcltigkeiten ...");
                        HydrasAbflusskurvenRepository hydrasAbflusskurvenRepository = new HydrasAbflusskurvenRepository(messstelleDatenbankConnection, hydrasMessstelle);
                        List<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeiten = hydrasAbflusskurvenRepository.g\u00fcltigkeiten();
                        for (Kurveng\u00fcltigkeit g\u00fcltigkeit : kurveng\u00fcltigkeiten) {
                            AbflusskurveEta etaKurven = hydrasAbflusskurvenRepository.etaKurven(g\u00fcltigkeit.virtuelleSondeId(), messstelle.get());
                            long abflusskurvenId = abflusskurvenRepository.speichereAbflusskurve(etaKurven.eta0());
                            abflusskurvenRepository.speichereAbflusskurve(etaKurven.eta1());
                            abflusskurvenRepository.speichereG\u00fcltigkeit(messstelle.get(), g\u00fcltigkeit, abflusskurvenId);
                        }
                        importLog.logge("    Kurveng\u00fcltigkeiten importiert: " + kurveng\u00fcltigkeiten.size() + " St\u00fcck");
                    }
                    catch (Exception e) {
                        importLog.logge("! " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    importLog.logge("! " + e.getMessage());
                }
            }
            importierteMessstellen.add(hydrasMessstelle);
            ++i;
        }
    }

    private static void importiereSensorFormelnAus(Optional<Path> sensorFormelDateiPfad) {
    }

    private static Optional<Path> benenneSSDateiXMLUmFallsVorhanden(HydrasArbeitsplatz arbeitsplatz, HydrasMessstelle messstelle, Logdatei importLog) {
        Path messstellenVerzeichnis = arbeitsplatz.messstellenVerzeichnis(messstelle);
        String alterDateiname = "SS_DATEI.XML";
        String neuerDateiname = "SENSOR_FORMELN.XML";
        Path alterDateiPfad = messstellenVerzeichnis.resolve("SS_DATEI.XML");
        if (Files.exists(alterDateiPfad, new LinkOption[0])) {
            importLog.logge("Eine SS_DATEI.XML existiert. Umbenennung zu SENSOR_FORMELN.XML");
            try {
                Path neuerDateiPfad = alterDateiPfad.resolveSibling("SENSOR_FORMELN.XML");
                Files.move(alterDateiPfad, neuerDateiPfad, new CopyOption[0]);
                return Optional.of(neuerDateiPfad);
            }
            catch (IOException e) {
                importLog.logge("Konnte SS_DATEI.XML nicht umbenennen. Grund: " + e.getMessage());
            }
        }
        return Optional.empty();
    }

    private static void l\u00f6scheExistierendeDaten(Logdatei importLog, MessstellenRepository ohydMessstellenRepository, AbflusskurvenRepository abflusskurvenRepository, ZeitreihenRepository zeitreihenRepository) {
        importLog.logge("L\u00f6sche alle Abflusskurven und Kurveng\u00fcltigkeiten ...");
        abflusskurvenRepository.l\u00f6scheAlleAbflusskurven();
        importLog.logge("L\u00f6sche alle Zeitreihen ...");
        zeitreihenRepository.l\u00f6scheAlleZeitreihen(importLog);
        importLog.logge("L\u00f6sche alle Notizen ...");
        zeitreihenRepository.l\u00f6scheAlleNotizen();
        importLog.logge("L\u00f6sche alle Terminwerte ...");
        zeitreihenRepository.l\u00f6scheAlleTerminwerte(importLog);
    }

    private static void importiereZeitreihen(StALU stalu, HydrasMessstelle messstelle, List<Sensor> sensoren, SensorMatrix sensorMatrix, Path zeitreihenDatenVerzeichnisRoh, Path zeitreihenDatenVerzeichnisEditiert, HydrasMessstelleRepository hydrasMessstelleRepository, ZeitreihenRepository zeitreihenRepository, Logdatei importLog) {
        for (Sensor sensor : sensoren) {
            try {
                Main.importiereZeitreihenF\u00fcrSensor(stalu, messstelle, sensor, sensorMatrix, zeitreihenDatenVerzeichnisRoh, zeitreihenDatenVerzeichnisEditiert, zeitreihenRepository, importLog);
                Main.importiereNotizenF\u00fcrSensor(stalu, messstelle, sensor, sensorMatrix, hydrasMessstelleRepository, zeitreihenRepository, importLog);
            }
            catch (Exception e) {
                importLog.logge("        ! Konnte Zeitreihen f\u00fcr Messstelle " + messstelle.pkz() + " / Sensor " + sensor.nummer() + " nicht importieren. " + e.getMessage());
            }
        }
    }

    private static void importiereZeitreihenF\u00fcrSensor(StALU stalu, HydrasMessstelle hydrasMessstelle, Sensor sensor, SensorMatrix sensorMatrix, Path zeitreihenDatenVerzeichnisRoh, Path zeitreihenDatenVerzeichnisEditiert, ZeitreihenRepository zeitreihenRepository, Logdatei importLog) {
        List<ZielDefinition> ziele = sensorMatrix.ziele(stalu, hydrasMessstelle, sensor.nummer());
        importLog.logge("    F\u00fcr Sensor " + sensor.nummer() + ": " + ziele);
        for (ZielDefinition ziel : ziele) {
            try {
                Messstelle messstelle = ziel.messstelle();
                List<ZeitWert> werte = Main.ladeWerte(ziel.zellWert(), messstelle, sensor, zeitreihenDatenVerzeichnisRoh, zeitreihenDatenVerzeichnisEditiert, importLog);
                int anzahlWerte = werte.size();
                Zeitreihe zeitreihe = new Zeitreihe(messstelle, ziel.zieltabelle(), werte);
                importLog.logge("        Importiere " + anzahlWerte + " Werte nach " + ziel.zieltabelle());
                if (zeitreihe.istWeitereZeitreihe()) {
                    WeitereZeitreihe weitereZeitreihe = new WeitereZeitreihe("Sensor " + sensor.nummer(), zeitreihe, Parameter.W);
                    zeitreihenRepository.f\u00fcgeWeitereZeitreiheEin(weitereZeitreihe);
                    continue;
                }
                zeitreihenRepository.f\u00fcgeZeitreiheEin(zeitreihe, ziel.skalierungsfaktor());
            }
            catch (Exception e) {
                String message = e.getMessage();
                message = message.replaceAll("Call getNextException to see other errors in the batch\\.", "");
                importLog.logge("        ! Konnte Zeitreihe f\u00fcr Messstelle " + hydrasMessstelle.pkz() + " / Sensor " + sensor.nummer() + " nicht nach " + ziel.zieltabelle() + " importieren. " + message);
            }
        }
    }

    private static void importiereNotizenF\u00fcrSensor(StALU stalu, HydrasMessstelle hydrasMessstelle, Sensor sensor, SensorMatrix sensorMatrix, HydrasMessstelleRepository hydrasMessstelleRepository, ZeitreihenRepository zeitreihenRepository, Logdatei importLog) {
        Optional<Messstelle> optionalMessstelle = Messstelle.ausPKZ(hydrasMessstelle.pkz());
        if (optionalMessstelle.isPresent()) {
            List<Notiz> notizen = hydrasMessstelleRepository.infosF\u00fcrSensor(sensor.nummer(), optionalMessstelle.get());
            importLog.logge("        Importiere " + notizen.size() + " Notizen f\u00fcr Sensor " + sensor.nummer());
            zeitreihenRepository.f\u00fcgeNotizenEin(notizen);
        }
        List<ZielDefinition> ziele = sensorMatrix.ziele(stalu, hydrasMessstelle, sensor.nummer());
        for (ZielDefinition ziel : ziele) {
            Messstelle messstelle = ziel.messstelle();
            if (ziel.zellWert() != ZellWert.termin) continue;
            List<Notiz> notizen = hydrasMessstelleRepository.infosF\u00fcrSensor(sensor.nummer(), messstelle);
            long anzahlTerminwerte = notizen.stream().filter(notiz -> notiz.wert().isPresent()).count();
            importLog.logge("        Importiere " + anzahlTerminwerte + " Terminwerte f\u00fcr Sensor " + sensor.nummer());
            if (ziel.zieltabelle().istWeitereZeitreihe()) {
                List<ZeitWert> werte = notizen.stream().map(Notiz::zeitWert).collect(Collectors.toList());
                Zeitreihe zeitreihe = new Zeitreihe(messstelle, ziel.zieltabelle(), werte);
                WeitereZeitreihe weitereZeitreihe = new WeitereZeitreihe("Sensor " + sensor.nummer() + " Terminwerte", zeitreihe, Parameter.W);
                zeitreihenRepository.f\u00fcgeWeitereZeitreiheEin(weitereZeitreihe);
                continue;
            }
            zeitreihenRepository.f\u00fcgeTerminwerteEin(notizen, ziel.zieltabelle(), ziel.skalierungsfaktor());
        }
    }

    private static List<ZeitWert> ladeWerte(ZellWert zellWert, Messstelle messstelle, Sensor sensor, Path zeitreihenDatenVerzeichnisRoh, Path zeitreihenDatenVerzeichnisEditiert, Logdatei importLog) throws IOException, ParseException {
        if (zellWert == ZellWert.termin) {
            return Collections.emptyList();
        }
        if (zellWert == ZellWert.roh || zellWert == ZellWert.editiert) {
            String dateiname;
            Path zeitreihenDatenVerzeichnis = zellWert == ZellWert.editiert ? zeitreihenDatenVerzeichnisEditiert : zeitreihenDatenVerzeichnisRoh;
            Path dateipfad = zeitreihenDatenVerzeichnis.resolve(dateiname = String.format("Export%010d_%s.txt", messstelle.nummer(), sensor.nummer()));
            if (!Files.exists(dateipfad, new LinkOption[0])) {
                importLog.logge("Datei existiert nicht: " + dateipfad);
                return Collections.emptyList();
            }
            HydrasZeitreihenRepository exportierteZeitreihenRepository = new HydrasZeitreihenRepository(dateipfad);
            return exportierteZeitreihenRepository.werte();
        }
        return Collections.emptyList();
    }

    private static <T> List<T> findeDuplikate(List<T> list) {
        HashSet elements = new HashSet();
        return list.stream().filter(n -> !elements.add(n)).collect(Collectors.toList());
    }
}

