/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.utils;

import com.googlecode.paradox.exceptions.ParadoxException;
import java.sql.SQLException;
import java.sql.Wrapper;

public final class Utils {
    private Utils() {
    }

    public static boolean isWrapperFor(Wrapper wrapper, Class<?> iFace) {
        return wrapper.getClass().isAssignableFrom(iFace);
    }

    public static <T> T unwrap(Wrapper wrapper, Class<T> iFace) throws SQLException {
        if (wrapper.isWrapperFor(iFace)) {
            return (T)wrapper;
        }
        throw new ParadoxException(ParadoxException.Error.TYPE_NOT_FOUND);
    }

    public static String removeSuffix(String name, String suffix) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) != -1 && name.substring(index + 1).equalsIgnoreCase(suffix)) {
            return name.substring(0, index);
        }
        return name;
    }

    public static String removeSuffix(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    public static <T extends Enum<?>> T searchEnum(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (!each.name().equalsIgnoreCase(search)) continue;
            return (T)each;
        }
        return null;
    }
}

