/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.utils;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.InternalException;
import com.googlecode.paradox.function.aggregate.IGroupingContext;
import com.googlecode.paradox.planner.context.SelectContext;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.rowset.ValuesComparator;
import com.googlecode.paradox.utils.CompareArray;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;

public final class FunctionalUtils {
    private FunctionalUtils() {
    }

    public static <T, E extends SQLException> Predicate<T> predicateWrapper(PredicateWithExceptions<T, E> fe) {
        return arg -> {
            try {
                return fe.test(arg);
            }
            catch (SQLException e) {
                throw new InternalException(e);
            }
        };
    }

    public static <T, R, E extends SQLException> Function<T, R> functionWrapper(FunctionWithExceptions<T, R, E> fe) {
        return arg -> {
            try {
                return fe.apply(arg);
            }
            catch (SQLException e) {
                throw new InternalException(e);
            }
        };
    }

    public static Predicate<Object[]> groupingByKeys(int[] indexes, int[] columns, ConnectionInfo connectionInfo) {
        ArrayList seen = new ArrayList();
        return value -> {
            Object[] current = seen.stream().filter(o -> FunctionalUtils.equalsAggregate(o, value, columns, connectionInfo)).findAny().orElse(null);
            if (current == null) {
                seen.add(value);
                return true;
            }
            Arrays.stream(indexes).forEach(index -> ((IGroupingContext)current[index]).process((IGroupingContext)value[index], connectionInfo));
            return false;
        };
    }

    public static FunctionWithExceptions<Object[], Object[], SQLException> removeGrouping(SelectContext context, int[] indexes, List<Column> columnsLoaded) {
        return value -> {
            for (int index : indexes) {
                if (value[index] == null) continue;
                value[index] = ((IGroupingContext)value[index]).toValue();
            }
            FunctionalUtils.processSecondPass(context, columnsLoaded, value);
            return value;
        };
    }

    private static void processSecondPass(SelectContext context, List<Column> columnsLoaded, Object[] value) throws SQLException {
        for (int i = 0; i < columnsLoaded.size(); ++i) {
            if (!columnsLoaded.get(i).isSecondPass()) continue;
            value[i] = columnsLoaded.get(i).getFunction().execute(context, value, columnsLoaded);
        }
    }

    private static boolean equalsAggregate(Object[] o1, Object[] o2, int[] columns, ConnectionInfo connectionInfo) {
        for (int i : columns) {
            if (o1[i] == o2[i]) {
                return true;
            }
            boolean ret = ValuesComparator.equals(o1[i], o2[i], connectionInfo);
            if (ret) continue;
            return false;
        }
        return true;
    }

    public static Predicate<Object[]> distinctByKey(List<Column> columnsLoaded, ConnectionInfo connectionInfo) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < columnsLoaded.size(); ++i) {
            if (columnsLoaded.get(i).isHidden()) continue;
            indexes.add(i);
        }
        TreeSet<Object[]> seen = new TreeSet<Object[]>(new CompareArray(indexes.stream().mapToInt(Integer::intValue).toArray(), connectionInfo));
        return seen::add;
    }

    @FunctionalInterface
    public static interface FunctionWithExceptions<T, R, E extends SQLException> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface PredicateWithExceptions<T, E extends SQLException> {
        public boolean test(T var1) throws E;
    }
}

