/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.utils;

import java.util.Locale;

public final class Expressions {
    private Expressions() {
    }

    public static boolean accept(Locale locale, String expression, String criteria, boolean caseSensitive, char escape) {
        int criterionIndex;
        if ("%".equals(criteria) || criteria == null) {
            return true;
        }
        char[] criterion = Expressions.getCharArrayWithCase(locale, criteria, caseSensitive);
        char[] exp = Expressions.getCharArrayWithCase(locale, expression, caseSensitive);
        int index = 0;
        for (criterionIndex = 0; criterionIndex < criterion.length && index < exp.length; ++criterionIndex) {
            char c = criterion[criterionIndex];
            if (c == '_') {
                ++index;
                continue;
            }
            if (c == '%') {
                index = Expressions.getIndex(criterion, exp, index, criterionIndex);
                continue;
            }
            if (Expressions.isEscapedChar(criterionIndex, criterion, escape)) {
                c = criterion[++criterionIndex];
            }
            if (c != exp[index]) break;
            ++index;
        }
        return index >= exp.length && criterionIndex == criterion.length;
    }

    private static int getIndex(char[] criterion, char[] expression, int expressionIndex, int criterionIndex) {
        int index = expressionIndex;
        if (criterionIndex + 1 >= criterion.length) {
            index = expression.length + 1;
        } else {
            char next = criterion[criterionIndex + 1];
            index = Expressions.nextIndex(expression, index, next);
        }
        return index;
    }

    private static boolean isEscapedChar(int currentIndex, char[] criterion, char escape) {
        boolean ret = false;
        if (criterion[currentIndex] == escape && currentIndex + 1 < criterion.length) {
            char next = criterion[currentIndex + 1];
            switch (next) {
                case '%': 
                case '\\': 
                case '_': {
                    ret = true;
                    break;
                }
                default: {
                    ret = false;
                }
            }
        }
        return ret;
    }

    private static int nextIndex(char[] expression, int currentIndex, char next) {
        int index;
        for (index = currentIndex; index < expression.length && next != expression[index]; ++index) {
        }
        return index;
    }

    private static char[] getCharArrayWithCase(Locale locale, String str, boolean caseSensitive) {
        if (str == null) {
            return new char[0];
        }
        if (caseSensitive) {
            return str.toCharArray();
        }
        return str.toUpperCase(locale).toCharArray();
    }
}

