/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.utils;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import java.sql.Date;
import java.util.GregorianCalendar;

public final class DateUtils {
    private static final int DAYS_PER_4_YEARS = 1461;
    private static final int DAYS_PER_400_YEARS = 146097;
    private static final int DAYS_PER_5_MONTHS = 153;
    private static final int SDN_OFFSET = 32045;

    private DateUtils() {
    }

    public static long gregorianToSdn(long inputYear, long inputMonth, long inputDay, ConnectionInfo connectionInfo) {
        long month;
        try {
            DateUtils.checkForDateBoundaries(inputYear, inputMonth, inputDay);
            DateUtils.checkYearBounds(inputYear, inputMonth, inputDay);
        }
        catch (ParadoxDataException e) {
            connectionInfo.addWarning(e);
            return 0L;
        }
        long year = DateUtils.fixYearBounds(inputYear);
        if (inputMonth > 2L) {
            month = inputMonth - 3L;
        } else {
            month = inputMonth + 9L;
            --year;
        }
        return year / 100L * 146097L / 4L + year % 100L * 1461L / 4L + (month * 153L + 2L) / 5L + inputDay - 32045L;
    }

    public static Date sdnToGregorian(long sdn) {
        if (sdn <= 0L) {
            return null;
        }
        long temp = (sdn + 32045L) * 4L - 1L;
        long century = temp / 146097L;
        temp = temp % 146097L / 4L * 4L + 3L;
        long year = century * 100L + temp / 1461L;
        long dayOfYear = temp % 1461L / 4L + 1L;
        temp = dayOfYear * 5L - 3L;
        long month = temp / 153L;
        long day = temp % 153L / 5L + 1L;
        if (month < 10L) {
            month += 3L;
        } else {
            ++year;
            month -= 9L;
        }
        if ((year -= 4800L) <= 0L) {
            --year;
        }
        GregorianCalendar calendar = new GregorianCalendar((int)year, (int)month - 1, (int)day);
        return new Date(calendar.getTime().getTime());
    }

    private static void checkForDateBoundaries(long inputYear, long inputMonth, long inputDay) throws ParadoxDataException {
        if (inputYear == 0L || inputYear < -4714L) {
            throw new ParadoxDataException(DataError.INVALID_DATE);
        }
        if (inputMonth <= 0L || inputMonth > 12L) {
            throw new ParadoxDataException(DataError.INVALID_DATE);
        }
        if (inputDay <= 0L || inputDay > 31L) {
            throw new ParadoxDataException(DataError.INVALID_DATE);
        }
    }

    private static void checkYearBounds(long inputYear, long inputMonth, long inputDay) throws ParadoxDataException {
        if (inputYear == -4714L) {
            if (inputMonth < 11L) {
                throw new ParadoxDataException(DataError.INVALID_DATE);
            }
            if (inputMonth == 11L && inputDay < 25L) {
                throw new ParadoxDataException(DataError.INVALID_DATE);
            }
        }
    }

    private static long fixYearBounds(long inputYear) {
        long year = inputYear < 0L ? inputYear + 4801L : inputYear + 4800L;
        return year;
    }
}

