/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.rowset;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.results.ParadoxType;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public final class ValuesConverter {
    private static final Map<Class<?>, BiFunction<Object, ConnectionInfo, Object>> CLASS_MAPPING = new HashMap();
    private static final Map<Integer, BiFunction<Object, ConnectionInfo, Object>> TYPE_MAPPING = new HashMap<Integer, BiFunction<Object, ConnectionInfo, Object>>();

    private ValuesConverter() {
    }

    public static <T> T convert(Object value, Class<T> type, ConnectionInfo connectionInfo) throws SQLException {
        try {
            return (T)CLASS_MAPPING.get(type).apply(value, connectionInfo);
        }
        catch (IllegalArgumentException e) {
            throw new ParadoxDataException(DataError.INVALID_CONVERSION, e, value);
        }
    }

    public static Object convert(Object value, int sqlType, ConnectionInfo connectionInfo) throws SQLException {
        try {
            return TYPE_MAPPING.get(sqlType).apply(value, connectionInfo);
        }
        catch (IllegalArgumentException e) {
            throw new ParadoxDataException(DataError.INVALID_CONVERSION, e, value);
        }
    }

    public static Object convert(Object value, ParadoxType type, ConnectionInfo connectionInfo) throws SQLException {
        try {
            return CLASS_MAPPING.get(type.getJavaClass()).apply(value, connectionInfo);
        }
        catch (IllegalArgumentException e) {
            throw new ParadoxDataException(DataError.INVALID_CONVERSION, e, value);
        }
    }

    public static Boolean getBoolean(Object value, ConnectionInfo connectionInfo) {
        Boolean ret = null;
        if (value instanceof Boolean) {
            ret = (Boolean)value;
        } else if (value instanceof Number) {
            ret = ((Number)value).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        } else if (value != null) {
            Integer i = ValuesConverter.getInteger(value, connectionInfo);
            ret = i != null ? (i == 0 ? Boolean.FALSE : Boolean.TRUE) : Boolean.valueOf(value.toString());
        }
        return ret;
    }

    public static Byte getByte(Object value, ConnectionInfo connectionInfo) {
        Byte ret = null;
        if (value instanceof Byte) {
            ret = (Byte)value;
        } else if (value instanceof Number) {
            ret = ((Number)value).byteValue();
        } else if (value instanceof Boolean) {
            ret = ((Boolean)value).booleanValue() ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        } else if (value != null) {
            try {
                ret = Byte.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        return ret;
    }

    public static Short getShort(Object value, ConnectionInfo connectionInfo) {
        Short ret = null;
        if (value instanceof Short) {
            ret = (Short)value;
        } else if (value instanceof Number) {
            ret = ((Number)value).shortValue();
        } else if (value instanceof Boolean) {
            ret = ((Boolean)value).booleanValue() ? Short.valueOf((short)1) : Short.valueOf((short)0);
        } else if (value != null) {
            try {
                ret = Short.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        return ret;
    }

    public static int getPositiveInteger(Object value, ConnectionInfo connectionInfo) throws ParadoxSyntaxErrorException {
        Integer size = ValuesConverter.getInteger(value, connectionInfo);
        if (size == null || size < 0) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, value);
        }
        return size;
    }

    public static Integer getInteger(Object value, ConnectionInfo connectionInfo) {
        Integer ret = null;
        if (value instanceof Integer) {
            ret = (Integer)value;
        } else if (value instanceof Number) {
            ret = ((Number)value).intValue();
        } else if (value instanceof Boolean) {
            ret = ((Boolean)value).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0);
        } else if (value != null) {
            try {
                ret = Integer.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
                try {
                    ret = new BigDecimal(value.toString()).intValue();
                }
                catch (NumberFormatException e1) {
                    connectionInfo.addWarning(e1);
                }
            }
        }
        return ret;
    }

    public static Long getLong(Object value, ConnectionInfo connectionInfo) {
        Long ret = null;
        if (value instanceof Long) {
            ret = (Long)value;
        } else if (value instanceof Number) {
            ret = ((Number)value).longValue();
        } else if (value instanceof Boolean) {
            ret = ((Boolean)value).booleanValue() ? Long.valueOf(1L) : Long.valueOf(0L);
        } else if (value != null) {
            try {
                ret = Long.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
                try {
                    ret = new BigDecimal(value.toString()).longValue();
                }
                catch (NumberFormatException e1) {
                    connectionInfo.addWarning(e1);
                }
            }
        }
        return ret;
    }

    public static BigDecimal getBigDecimal(Object value, ConnectionInfo connectionInfo) {
        BigDecimal ret = null;
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            ret = BigDecimal.valueOf(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            ret = ((Boolean)value).booleanValue() ? BigDecimal.ONE : BigDecimal.ZERO;
        } else if (value != null) {
            try {
                ret = new BigDecimal(value.toString());
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        return ret;
    }

    public static Float getFloat(Object value, ConnectionInfo connectionInfo) {
        Float ret = null;
        if (value instanceof Float) {
            ret = (Float)value;
        } else if (value instanceof Number) {
            ret = Float.valueOf(((Number)value).floatValue());
        } else if (value instanceof Boolean) {
            ret = ((Boolean)value).booleanValue() ? Float.valueOf(1.0f) : Float.valueOf(0.0f);
        } else if (value != null) {
            try {
                ret = Float.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        return ret;
    }

    public static Double getDouble(Object value, ConnectionInfo connectionInfo) {
        Double ret = null;
        if (value instanceof Double) {
            ret = (Double)value;
        } else if (value instanceof Number) {
            ret = ((Number)value).doubleValue();
        } else if (value instanceof Boolean) {
            ret = ((Boolean)value).booleanValue() ? Double.valueOf(1.0) : Double.valueOf(0.0);
        } else if (value != null) {
            try {
                ret = Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        return ret;
    }

    public static Time removeDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(1, 0);
        c.set(2, 0);
        c.set(5, 0);
        return new Time(c.getTimeInMillis());
    }

    public static Time getTime(Object value, ConnectionInfo connectionInfo) {
        Time ret = null;
        if (value instanceof Time) {
            ret = (Time)value;
        } else if (value instanceof java.util.Date) {
            ret = ValuesConverter.removeDate((java.util.Date)value);
        } else if (value != null) {
            try {
                ret = Time.valueOf(value.toString().trim());
            }
            catch (IllegalArgumentException e) {
                connectionInfo.addWarning(e);
                try {
                    Date date = Date.valueOf(value.toString());
                    ret = ValuesConverter.removeDate(date);
                }
                catch (IllegalArgumentException e1) {
                    connectionInfo.addWarning(e1);
                    try {
                        Timestamp timestamp = Timestamp.valueOf(value.toString());
                        ret = ValuesConverter.removeDate(timestamp);
                    }
                    catch (IllegalArgumentException e2) {
                        connectionInfo.addWarning(e2);
                    }
                }
            }
        }
        return ret;
    }

    public static Timestamp getTimestamp(Object value, ConnectionInfo connectionInfo) {
        Timestamp ret = null;
        if (value instanceof Timestamp) {
            ret = (Timestamp)value;
        } else if (value instanceof java.util.Date) {
            ret = new Timestamp(((java.util.Date)value).getTime());
        } else if (value != null) {
            try {
                ret = Timestamp.valueOf(value.toString().trim());
            }
            catch (IllegalArgumentException e) {
                connectionInfo.addWarning(e);
                try {
                    Date date = Date.valueOf(value.toString());
                    ret = new Timestamp(date.getTime());
                }
                catch (IllegalArgumentException e1) {
                    connectionInfo.addWarning(e1);
                    try {
                        Time time = Time.valueOf(value.toString());
                        ret = new Timestamp(time.getTime());
                    }
                    catch (IllegalArgumentException e2) {
                        connectionInfo.addWarning(e2);
                    }
                }
            }
        }
        return ret;
    }

    public static Date removeTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return new Date(c.getTimeInMillis());
    }

    public static Date getDate(Object value, ConnectionInfo connectionInfo) {
        Date ret = null;
        if (value instanceof Date) {
            ret = (Date)value;
        } else if (value instanceof java.util.Date) {
            ret = ValuesConverter.removeTime((java.util.Date)value);
        } else if (value != null) {
            try {
                ret = Date.valueOf(value.toString().trim());
            }
            catch (IllegalArgumentException e) {
                connectionInfo.addWarning(e);
                try {
                    Timestamp timestamp = Timestamp.valueOf(value.toString());
                    ret = ValuesConverter.removeTime(timestamp);
                }
                catch (IllegalArgumentException e1) {
                    connectionInfo.addWarning(e1);
                }
            }
        }
        return ret;
    }

    public static byte[] getByteArray(Object value, ConnectionInfo connectionInfo) {
        byte[] ret = null;
        if (value instanceof byte[]) {
            ret = (byte[])value;
        } else if (value != null) {
            ret = value.toString().getBytes(StandardCharsets.UTF_8);
        }
        return ret;
    }

    public static String getString(Object value, ConnectionInfo connectionInfo) {
        String ret = null;
        if (value instanceof String) {
            ret = (String)value;
        } else if (value instanceof byte[]) {
            ret = new String((byte[])value, StandardCharsets.UTF_8);
        } else if (value != null) {
            ret = value.toString();
        }
        return ret;
    }

    public static byte[] getBytes(InputStream inputStream, int length) throws ParadoxDataException {
        byte[] ret = null;
        if (inputStream != null) {
            try (DataInputStream dis = new DataInputStream(inputStream);){
                ret = new byte[length];
                dis.readFully(ret);
            }
            catch (IOException e) {
                throw new ParadoxDataException(DataError.INVALID_CONVERSION, e, inputStream);
            }
        }
        return ret;
    }

    public static String getChars(Reader reader, int length) throws ParadoxDataException {
        String ret = null;
        if (reader != null) {
            try {
                char[] buffer = new char[length];
                if (reader.read(buffer) != length) {
                    throw new ParadoxDataException(DataError.INVALID_CONVERSION, reader);
                }
                ret = new String(buffer);
            }
            catch (IOException e) {
                throw new ParadoxDataException(DataError.INVALID_CONVERSION, e, reader);
            }
        }
        return ret;
    }

    public static String convert(byte[] bytes, Charset charset) throws ParadoxDataException {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        ByteBuffer input = ByteBuffer.wrap(bytes);
        try {
            return decoder.decode(input).toString();
        }
        catch (CharacterCodingException e) {
            throw new ParadoxDataException(DataError.ERROR_LOADING_DATA, e);
        }
    }

    static {
        CLASS_MAPPING.put(BigDecimal.class, ValuesConverter::getBigDecimal);
        CLASS_MAPPING.put(Boolean.class, ValuesConverter::getBoolean);
        CLASS_MAPPING.put(Byte.class, ValuesConverter::getByte);
        CLASS_MAPPING.put(byte[].class, ValuesConverter::getByteArray);
        CLASS_MAPPING.put(Date.class, ValuesConverter::getDate);
        CLASS_MAPPING.put(Double.class, ValuesConverter::getDouble);
        CLASS_MAPPING.put(Float.class, ValuesConverter::getFloat);
        CLASS_MAPPING.put(Integer.class, ValuesConverter::getInteger);
        CLASS_MAPPING.put(Long.class, ValuesConverter::getLong);
        CLASS_MAPPING.put(Short.class, ValuesConverter::getShort);
        CLASS_MAPPING.put(String.class, ValuesConverter::getString);
        CLASS_MAPPING.put(Time.class, ValuesConverter::getTime);
        CLASS_MAPPING.put(Timestamp.class, ValuesConverter::getTimestamp);
        TYPE_MAPPING.put(16, ValuesConverter::getBoolean);
        TYPE_MAPPING.put(-2, ValuesConverter::getByteArray);
        TYPE_MAPPING.put(2004, ValuesConverter::getByteArray);
        TYPE_MAPPING.put(91, ValuesConverter::getDate);
        TYPE_MAPPING.put(8, ValuesConverter::getDouble);
        TYPE_MAPPING.put(2, ValuesConverter::getDouble);
        TYPE_MAPPING.put(6, ValuesConverter::getFloat);
        TYPE_MAPPING.put(4, ValuesConverter::getInteger);
        TYPE_MAPPING.put(2005, ValuesConverter::getString);
        TYPE_MAPPING.put(2011, ValuesConverter::getString);
        TYPE_MAPPING.put(12, ValuesConverter::getString);
        TYPE_MAPPING.put(-9, ValuesConverter::getString);
        TYPE_MAPPING.put(92, ValuesConverter::getTime);
        TYPE_MAPPING.put(93, ValuesConverter::getTimestamp);
        TYPE_MAPPING.put(2014, ValuesConverter::getTimestamp);
    }
}

