/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.rowset;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.function.IntPredicate;

public final class ValuesComparator {
    private static final double EPSILON = 4.0E-323;

    private ValuesComparator() {
    }

    public static boolean compare(Object o1, Object o2, IntPredicate condition, ConnectionInfo connectionInfo) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return condition.test(ValuesComparator.compare(o1, o2, connectionInfo));
    }

    public static boolean equals(Object o1, Object o2, ConnectionInfo connectionInfo) {
        Object n1;
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof Boolean || o2 instanceof Boolean) {
            Boolean n12 = ValuesConverter.getBoolean(o1, connectionInfo);
            Boolean n2 = ValuesConverter.getBoolean(o2, connectionInfo);
            return n12.equals(n2);
        }
        if (o1 instanceof Byte || o2 instanceof Byte) {
            try {
                Byte n13 = ValuesConverter.getByte(o1, connectionInfo);
                Byte n2 = ValuesConverter.getByte(o2, connectionInfo);
                return n13.equals(n2);
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Double || o2 instanceof Double) {
            try {
                double n14 = ValuesConverter.getDouble(o1, connectionInfo);
                double n2 = ValuesConverter.getDouble(o2, connectionInfo);
                return Math.abs(n14 - n2) < 4.0E-323;
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            try {
                n1 = ValuesConverter.getBigDecimal(o1, connectionInfo);
                BigDecimal n2 = ValuesConverter.getBigDecimal(o2, connectionInfo);
                n1 = ((BigDecimal)n1).setScale(Math.max(((BigDecimal)n1).scale(), n2.scale()), RoundingMode.UNNECESSARY);
                n2 = n2.setScale(Math.max(((BigDecimal)n1).scale(), n2.scale()), RoundingMode.UNNECESSARY);
                return ((BigDecimal)n1).equals(n2);
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Integer || o2 instanceof Integer) {
            try {
                n1 = ValuesConverter.getInteger(o1, connectionInfo);
                Integer n2 = ValuesConverter.getInteger(o2, connectionInfo);
                return ((Integer)n1).equals(n2);
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Long || o2 instanceof Long) {
            try {
                n1 = ValuesConverter.getLong(o1, connectionInfo);
                Long n2 = ValuesConverter.getLong(o2, connectionInfo);
                return ((Long)n1).equals(n2);
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Time || o2 instanceof Time) {
            try {
                n1 = ValuesConverter.getTime(o1, connectionInfo);
                Time n2 = ValuesConverter.getTime(o2, connectionInfo);
                return ((Date)n1).equals(n2);
            }
            catch (IllegalArgumentException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Timestamp || o2 instanceof Timestamp) {
            try {
                n1 = ValuesConverter.getTimestamp(o1, connectionInfo);
                Timestamp n2 = ValuesConverter.getTimestamp(o2, connectionInfo);
                return ((Timestamp)n1).equals(n2);
            }
            catch (IllegalArgumentException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof java.sql.Date || o2 instanceof java.sql.Date) {
            try {
                n1 = ValuesConverter.getDate(o1, connectionInfo);
                java.sql.Date n2 = ValuesConverter.getDate(o2, connectionInfo);
                return ((Date)n1).equals(n2);
            }
            catch (IllegalArgumentException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof String || o2 instanceof String) {
            n1 = ValuesConverter.getString(o1, connectionInfo);
            String n2 = ValuesConverter.getString(o2, connectionInfo);
            return ((String)n1).length() == n2.length() && ((String)n1).equals(n2);
        }
        if (o1 instanceof byte[] || o2 instanceof byte[]) {
            n1 = ValuesConverter.getByteArray(o1, connectionInfo);
            byte[] n2 = ValuesConverter.getByteArray(o2, connectionInfo);
            return Arrays.equals((byte[])n1, n2);
        }
        return false;
    }

    public static int compare(Object o1, Object o2, ConnectionInfo connectionInfo) {
        Object n1;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 instanceof Boolean || o2 instanceof Boolean) {
            Boolean n12 = ValuesConverter.getBoolean(o1, connectionInfo);
            Boolean n2 = ValuesConverter.getBoolean(o2, connectionInfo);
            return n12.compareTo(n2);
        }
        if (o1 instanceof Double || o2 instanceof Double) {
            try {
                Double n13 = ValuesConverter.getDouble(o1, connectionInfo);
                Double n2 = ValuesConverter.getDouble(o2, connectionInfo);
                return n13.compareTo(n2);
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            try {
                BigDecimal n14 = ValuesConverter.getBigDecimal(o1, connectionInfo);
                BigDecimal n2 = ValuesConverter.getBigDecimal(o2, connectionInfo);
                return n14.compareTo(n2);
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Byte || o2 instanceof Byte) {
            try {
                n1 = ValuesConverter.getByte(o1, connectionInfo);
                Byte n2 = ValuesConverter.getByte(o2, connectionInfo);
                return ((Byte)n1).compareTo(n2);
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Integer || o2 instanceof Integer) {
            try {
                n1 = ValuesConverter.getInteger(o1, connectionInfo);
                Integer n2 = ValuesConverter.getInteger(o2, connectionInfo);
                return ((Integer)n1).compareTo(n2);
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Long || o2 instanceof Long) {
            try {
                n1 = ValuesConverter.getLong(o1, connectionInfo);
                Long n2 = ValuesConverter.getLong(o2, connectionInfo);
                return ((Long)n1).compareTo(n2);
            }
            catch (NumberFormatException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Time || o2 instanceof Time) {
            try {
                n1 = ValuesConverter.getTime(o1, connectionInfo);
                Time n2 = ValuesConverter.getTime(o2, connectionInfo);
                return ((Date)n1).compareTo(n2);
            }
            catch (IllegalArgumentException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof Timestamp || o2 instanceof Timestamp) {
            try {
                n1 = ValuesConverter.getTimestamp(o1, connectionInfo);
                Timestamp n2 = ValuesConverter.getTimestamp(o2, connectionInfo);
                return ((Timestamp)n1).compareTo(n2);
            }
            catch (IllegalArgumentException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof java.sql.Date || o2 instanceof java.sql.Date) {
            try {
                n1 = ValuesConverter.getDate(o1, connectionInfo);
                java.sql.Date n2 = ValuesConverter.getDate(o2, connectionInfo);
                return ((Date)n1).compareTo(n2);
            }
            catch (IllegalArgumentException e) {
                connectionInfo.addWarning(e);
            }
        }
        if (o1 instanceof String || o2 instanceof String) {
            n1 = ValuesConverter.getString(o1, connectionInfo);
            String n2 = ValuesConverter.getString(o2, connectionInfo);
            return ((String)n1).compareTo(n2);
        }
        if (o1 instanceof byte[] || o2 instanceof byte[]) {
            byte[] n2;
            n1 = ValuesConverter.getByteArray(o1, connectionInfo);
            if (Arrays.equals((byte[])n1, n2 = ValuesConverter.getByteArray(o2, connectionInfo))) {
                return 0;
            }
            return -1;
        }
        return -1;
    }
}

