/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.rowset;

import com.googlecode.paradox.exceptions.ParadoxException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Objects;

public final class ParadoxClob
implements Clob {
    private String value;

    public ParadoxClob(String value) {
        this.value = value;
    }

    @Override
    public void free() {
    }

    @Override
    public InputStream getAsciiStream() {
        if (this.value != null) {
            return new ByteArrayInputStream(this.value.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    @Override
    public Reader getCharacterStream() {
        return new StringReader(this.value);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (pos < 1L) {
            throw new ParadoxException(ParadoxException.Error.INVALID_POSITION_SPECIFIED);
        }
        if (length < 0L) {
            throw new ParadoxException(ParadoxException.Error.INVALID_LENGTH_SPECIFIED);
        }
        int endPos = (int)(pos - 1L + length);
        if (pos > (long)this.value.length()) {
            return new StringReader("");
        }
        if (endPos > this.value.length()) {
            return new StringReader(this.value.substring((int)pos - 1));
        }
        return new StringReader(this.value.substring((int)pos - 1, endPos));
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new ParadoxException(ParadoxException.Error.INVALID_POSITION_SPECIFIED);
        }
        if (length < 0) {
            throw new ParadoxException(ParadoxException.Error.INVALID_LENGTH_SPECIFIED);
        }
        int endPos = (int)(pos - 1L + (long)length);
        if (pos > (long)this.value.length()) {
            return "";
        }
        if (endPos > this.value.length()) {
            return this.value.substring((int)pos - 1);
        }
        return this.value.substring((int)pos - 1, endPos);
    }

    @Override
    public long length() {
        return this.value.length();
    }

    @Override
    public long position(Clob search, long start) {
        return 0L;
    }

    @Override
    public long position(String search, long start) {
        return 0L;
    }

    @Override
    public OutputStream setAsciiStream(long pos) {
        return null;
    }

    @Override
    public Writer setCharacterStream(long pos) {
        return null;
    }

    @Override
    public int setString(long pos, String str) {
        return 0;
    }

    @Override
    public int setString(long pos, String str, int offset, int len) {
        return 0;
    }

    @Override
    public void truncate(long length) throws SQLException {
        if (length > (long)this.value.length()) {
            throw new ParadoxException(ParadoxException.Error.INVALID_LENGTH_SPECIFIED);
        }
        this.value = length == 0L ? "" : this.value.substring(0, (int)length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParadoxClob that = (ParadoxClob)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

