/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.rowset;

import com.googlecode.paradox.exceptions.ParadoxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public final class ParadoxBlob
implements Blob {
    private static final byte[] EMPTY_BLOB = new byte[0];
    private byte[] value;

    public ParadoxBlob(byte[] value) {
        this.value = value;
    }

    private static int areEquals(byte[] array1, int offset, byte[] array2) {
        int ret = -1;
        if (array2.length + offset <= array1.length) {
            int loop;
            for (loop = 0; loop < array2.length && array1[loop + offset] == array2[loop]; ++loop) {
            }
            if (loop == array2.length) {
                ret = offset;
            }
        }
        return ret;
    }

    @Override
    public void free() {
        this.value = EMPTY_BLOB;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) {
        return new ByteArrayInputStream(this.getBytes(pos, (int)length));
    }

    @Override
    public long length() {
        return this.value.length;
    }

    @Override
    public InputStream getBinaryStream() {
        return new ByteArrayInputStream(this.value);
    }

    @Override
    public byte[] getBytes(long pos, int length) {
        if (pos <= 0L) {
            pos = 1L;
        }
        int endPos = (int)(pos - 1L + (long)length);
        return Arrays.copyOfRange(this.value, (int)pos - 1, endPos);
    }

    @Override
    public long position(byte[] pattern, long start) throws ParadoxException {
        if (start <= 0L) {
            throw new ParadoxException(ParadoxException.Error.INVALID_POSITION_SPECIFIED);
        }
        for (int loop = (int)start - 1; loop <= this.value.length - pattern.length; ++loop) {
            int pos = ParadoxBlob.areEquals(this.value, loop, pattern);
            if (pos == -1) continue;
            return (long)pos + 1L;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws ParadoxException {
        if (pos <= 0L) {
            throw new ParadoxException(ParadoxException.Error.INVALID_POSITION_SPECIFIED);
        }
        if ((long)this.value.length < pos - 1L + (long)bytes.length) {
            this.value = Arrays.copyOf(this.value, (int)pos - 1 + bytes.length);
        }
        System.arraycopy(bytes, 0, this.value, (int)pos - 1, bytes.length);
        return bytes.length;
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return this.setBytes(pos, Arrays.copyOfRange(bytes, offset, len));
    }

    @Override
    public OutputStream setBinaryStream(long pos) {
        return new BlobStream(this);
    }

    @Override
    public void truncate(long length) throws SQLException {
        if (length > (long)this.value.length) {
            throw new ParadoxException(ParadoxException.Error.INVALID_LENGTH_SPECIFIED);
        }
        this.value = length == 0L ? EMPTY_BLOB : Arrays.copyOf(this.value, (int)length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParadoxBlob that = (ParadoxBlob)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    static /* synthetic */ byte[] access$002(ParadoxBlob x0, byte[] x1) {
        x0.value = x1;
        return x1;
    }

    private static class BlobStream
    extends ByteArrayOutputStream {
        private final ParadoxBlob parent;

        public BlobStream(ParadoxBlob parent) {
            this.parent = parent;
        }

        @Override
        public void close() throws IOException {
            ParadoxBlob.access$002(this.parent, this.toByteArray());
            super.close();
        }
    }
}

