/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.rowset;

import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.results.Column;
import java.sql.SQLException;
import java.util.List;

public class DataNavigation
implements AutoCloseable {
    private boolean closed;
    private List<? extends Object[]> values;
    private Object[] currentRow;
    private Object lastValue;
    private int index = -1;
    private int fetchDirection = 1000;
    private final int[] columns;

    public DataNavigation(List<Column> columns, List<? extends Object[]> values) {
        this.columns = columns.stream().mapToInt(Column::getIndex).toArray();
        this.values = values;
    }

    public Object getColumnValue(int columnIndex) throws SQLException {
        this.verifyStatus();
        this.verifyRow();
        int currentIndex = -1;
        for (int loop = 0; loop < this.columns.length; ++loop) {
            int column = this.columns[loop];
            if (column != columnIndex) continue;
            currentIndex = loop;
            break;
        }
        if (currentIndex == -1) {
            throw new ParadoxException(ParadoxException.Error.INVALID_COLUMN_INDEX, columnIndex);
        }
        this.lastValue = this.currentRow[currentIndex];
        return this.lastValue;
    }

    public int getFetchDirection() throws SQLException {
        this.verifyStatus();
        return this.fetchDirection;
    }

    public void setFetchDirection(int fetchDirection) throws SQLException {
        this.verifyStatus();
        if (fetchDirection != 1000 && fetchDirection != 1001) {
            throw new ParadoxException(ParadoxException.Error.INVALID_FETCH_DIRECTION, fetchDirection);
        }
        this.fetchDirection = fetchDirection;
    }

    public Object getLastValue() throws SQLException {
        this.verifyStatus();
        return this.lastValue;
    }

    public boolean absolute(int row) throws SQLException {
        boolean ret;
        this.verifyStatus();
        if (row >= 0) {
            if (row <= this.values.size()) {
                this.index = row - 1;
                ret = true;
            } else {
                this.index = this.values.size();
                ret = false;
            }
        } else if (this.values.size() + row >= 0) {
            this.index = this.values.size() + row;
            ret = true;
        } else {
            this.index = -1;
            ret = false;
        }
        this.updateCurrentRow();
        return ret;
    }

    public boolean first() throws SQLException {
        this.verifyStatus();
        if (this.values.isEmpty()) {
            return false;
        }
        this.index = 0;
        this.updateCurrentRow();
        return true;
    }

    public void afterLast() throws SQLException {
        this.verifyStatus();
        if (!this.values.isEmpty()) {
            this.index = this.values.size();
            this.updateCurrentRow();
        }
    }

    public void beforeFirst() throws SQLException {
        this.verifyStatus();
        this.index = -1;
        this.updateCurrentRow();
    }

    public boolean isAfterLast() throws SQLException {
        this.verifyStatus();
        return this.index >= this.values.size() || this.values.isEmpty();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.verifyStatus();
        return this.index < 0;
    }

    public int getRow() throws SQLException {
        this.verifyStatus();
        if (this.index == -1 || this.index == this.values.size()) {
            return 0;
        }
        return this.index + 1;
    }

    public boolean isFirst() throws SQLException {
        this.verifyStatus();
        return this.index == 0;
    }

    public boolean isLast() throws SQLException {
        this.verifyStatus();
        return this.index == this.values.size() - 1;
    }

    public boolean last() throws SQLException {
        this.verifyStatus();
        if (this.values.isEmpty()) {
            return false;
        }
        this.index = this.values.size() - 1;
        this.updateCurrentRow();
        return true;
    }

    public boolean relative(int rows) throws SQLException {
        this.verifyStatus();
        if (rows > 0) {
            if (this.index + rows < this.values.size()) {
                this.index += rows;
            } else {
                this.last();
            }
        } else if (this.index + rows >= 0) {
            this.index += rows;
        } else {
            this.first();
        }
        this.updateCurrentRow();
        return true;
    }

    @Override
    public void close() {
        this.closed = true;
        this.values = null;
        this.currentRow = null;
    }

    private void verifyRow() throws SQLException {
        if (this.index == -1) {
            throw new ParadoxException(ParadoxException.Error.USE_NEXT_FIRST);
        }
        if (this.index == this.values.size()) {
            throw new ParadoxException(ParadoxException.Error.NO_MORE_ROWS);
        }
    }

    private void verifyStatus() throws SQLException {
        if (this.closed) {
            throw new ParadoxException(ParadoxException.Error.RESULT_SET_CLOSED);
        }
    }

    private void updateCurrentRow() {
        this.currentRow = this.index == -1 || this.index == this.values.size() ? null : this.values.get(this.index);
    }

    public boolean next() {
        if (this.fetchDirection == 1000) {
            return this.moveNext();
        }
        return this.movePrevious();
    }

    public boolean previous() {
        if (this.fetchDirection == 1000) {
            return this.movePrevious();
        }
        return this.moveNext();
    }

    private boolean moveNext() {
        if (this.index < this.values.size()) {
            ++this.index;
        }
        this.updateCurrentRow();
        return this.index != this.values.size();
    }

    private boolean movePrevious() {
        if (this.index != -1) {
            --this.index;
        }
        this.updateCurrentRow();
        return this.index != -1;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "rows: " + this.values.size() + " current row: " + this.index;
    }
}

