/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.results;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;

public enum ParadoxType implements SQLType
{
    VARCHAR(1, 12, true, String.class, 0, 255, true),
    CHAR(1, 1, false, String.class, 0, 255, true),
    DATE(2, 91, true, Date.class, 0, 4, true),
    INTEGER(3, 4, true, Integer.class, 0, 2, true),
    LONG(4, 4, true, Integer.class, 0, 4, true),
    CURRENCY(5, 8, true, Double.class, 10, 4, true),
    NUMBER(6, 2, true, Double.class, 6, 4, true),
    NUMERIC(6, 2, true, Double.class, 6, 4, true),
    DECIMAL(6, 3, false, Double.class, 6, 4, true),
    BOOLEAN(9, 16, true, Boolean.class, 0, 1, true),
    MEMO(12, 2005, true, Clob.class, 0, 0, true),
    BLOB(13, 2004, true, byte[].class, 0, 0, true),
    FORMATTED_MEMO(14, 2005, true, Clob.class, 0, 0, true),
    OLE(15, 2004, true, byte[].class, 0, 0, true),
    GRAPHIC(16, 2004, true, byte[].class, 0, 0, true),
    TIME(20, 92, true, Time.class, 0, 4, true),
    TIME_WITH_TIMEZONE(20, 2013, false, Time.class, 0, 4, true),
    TIMESTAMP(21, 93, true, Timestamp.class, 0, 8, true),
    TIMESTAMP_WITH_TIMEZONE(21, 2014, false, Timestamp.class, 0, 8, true),
    AUTO_INCREMENT(22, 4, true, Integer.class, 0, 4, true),
    BCD(23, 2, true, BigDecimal.class, 2, 32, true),
    BYTES(24, -2, true, byte[].class, 0, 255, true),
    NULL(0, 0, false, Object.class, 0, 4, false);

    private static final ParadoxType[] VALUES;
    private final int sqlType;
    private final int type;
    private final boolean vendorSpecific;
    private final Class<?> javaClass;
    private final int precision;
    private final int size;
    private final boolean searchable;

    private ParadoxType(int type, int sqlType, boolean vendorSpecific, Class<?> javaClass, int precision, int size, boolean searchable) {
        this.type = (byte)type;
        this.sqlType = sqlType;
        this.vendorSpecific = vendorSpecific;
        this.javaClass = javaClass;
        this.precision = precision;
        this.size = size;
        this.searchable = searchable;
    }

    public static ParadoxType valueOfVendor(int type) {
        for (ParadoxType typeName : VALUES) {
            if (!typeName.vendorSpecific || typeName.type != type) continue;
            return typeName;
        }
        return NULL;
    }

    public static ParadoxType valueOf(int type) {
        for (ParadoxType sqlType : (ParadoxType[])ParadoxType.class.getEnumConstants()) {
            if (type != sqlType.sqlType) continue;
            return sqlType;
        }
        throw new IllegalArgumentException("The type " + type + " is not a valid Types.java value.");
    }

    public static ParadoxType valueOf(Class<?> desiredClass) {
        for (ParadoxType sqlType : (ParadoxType[])ParadoxType.class.getEnumConstants()) {
            if (desiredClass != sqlType.javaClass) continue;
            return sqlType;
        }
        throw new IllegalArgumentException("The class " + desiredClass + " is not a supported class name.");
    }

    @Override
    public String getVendor() {
        return "com.googlecode.paradox";
    }

    @Override
    public Integer getVendorTypeNumber() {
        return this.type;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    @Override
    public String getName() {
        return JDBCType.valueOf(this.sqlType).name();
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public Integer getRadix() {
        switch (this) {
            case INTEGER: 
            case LONG: 
            case CURRENCY: 
            case DECIMAL: 
            case NUMBER: 
            case NUMERIC: 
            case BCD: 
            case AUTO_INCREMENT: {
                return 10;
            }
        }
        return null;
    }

    public boolean isNumeric() {
        return this.getRadix() != null;
    }

    static {
        VALUES = ParadoxType.values();
    }
}

