/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.results;

import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.planner.nodes.FunctionNode;
import com.googlecode.paradox.planner.nodes.ParameterNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.results.ParadoxType;
import java.util.Objects;

public final class Column {
    private final boolean nullable;
    private Field field;
    private int index;
    private String name;
    private int precision;
    private int size;
    private ParadoxType type;
    private String remarks;
    private int columnType;
    private boolean hidden;
    private Object value;
    private FunctionNode function;
    private ParameterNode parameter;

    public Column(Field field) {
        this(field.getAlias(), field.getType());
        this.field = field;
        this.precision = field.getPrecision();
    }

    public Column(ParameterNode parameter) {
        this(parameter.getAlias(), ParadoxType.NULL);
        this.parameter = parameter;
    }

    public Column(ValueNode node) {
        this(node.getAlias(), node.getType());
        this.value = node.getName();
    }

    public Column(FunctionNode node) {
        this(node.getAlias(), node.getType());
        this.function = node;
    }

    public Column(String name, ParadoxType type, String remarks, int index, boolean nullable, int columnType) {
        this.name = name;
        this.type = type;
        this.precision = type.getPrecision();
        this.size = type.getSize();
        this.remarks = remarks;
        this.index = index;
        this.nullable = nullable;
        this.columnType = columnType;
    }

    public Column(String name, ParadoxType type) {
        this.name = name;
        this.type = type;
        this.nullable = type != ParadoxType.AUTO_INCREMENT;
    }

    public boolean isThis(Table table) {
        return this.field != null && this.field.getTable().getName().equalsIgnoreCase(table.getName()) && this.field.getTable().getSchemaName().equalsIgnoreCase(table.getSchemaName());
    }

    public Field getField() {
        return this.field;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        if (this.function != null) {
            this.function.setIndex(index);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        if (this.isSigned()) {
            return this.precision;
        }
        return 0;
    }

    public String getTableName() {
        return this.field.getTable().getName();
    }

    public ParadoxType getType() {
        return this.type;
    }

    public void setType(ParadoxType type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isAutoIncrement() {
        return this.field != null && this.field.getType() == ParadoxType.AUTO_INCREMENT;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isCurrency() {
        return this.field != null && this.field.getType() == ParadoxType.CURRENCY;
    }

    public boolean isSearchable() {
        return this.type.isSearchable();
    }

    public boolean isWritable() {
        return false;
    }

    public Integer getOctets() {
        if (this.type == ParadoxType.BCD) {
            return 17;
        }
        return this.size;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public FunctionNode getFunction() {
        return this.function;
    }

    public void setFunction(FunctionNode function) {
        this.function = function;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isSigned() {
        return this.type == ParadoxType.DECIMAL || this.type == ParadoxType.NUMBER || this.type == ParadoxType.CURRENCY || this.type == ParadoxType.INTEGER;
    }

    public int getSize() {
        return this.size;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public ParameterNode getParameter() {
        return this.parameter;
    }

    public boolean isSecondPass() {
        if (this.function != null) {
            return this.function.isSecondPass();
        }
        return false;
    }

    public Integer getRadix() {
        return this.type.getRadix();
    }

    public String toString() {
        if (this.field == null) {
            return this.name;
        }
        if (!Objects.equals(this.field.getName(), this.name)) {
            return this.field.toString() + " AS " + this.name;
        }
        return this.field.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        boolean ret = this.field != null ? Objects.equals(this.field, column.field) : (this.function != null ? this.function.equals(column.function) : Objects.equals(this.name, column.name));
        return ret;
    }

    public int hashCode() {
        if (this.field != null) {
            return Objects.hash(this.field);
        }
        if (this.function != null) {
            return this.function.hashCode();
        }
        return Objects.hash(this.name);
    }
}

