/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.plan;

import com.googlecode.paradox.planner.collections.FixedValueCollection;
import com.googlecode.paradox.planner.context.Context;
import com.googlecode.paradox.planner.nodes.PlanTableNode;
import com.googlecode.paradox.results.Column;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

final class TableJoiner {
    private TableJoiner() {
    }

    public static Collection<Object[]> processJoinByType(Context context, List<Column> columnsLoaded, Collection<Object[]> rawData, PlanTableNode table, Collection<Object[]> tableData) throws SQLException {
        Collection<Object[]> localValues;
        switch (table.getJoinType()) {
            case RIGHT: {
                localValues = TableJoiner.processRightJoin(context, columnsLoaded, rawData, table, tableData);
                break;
            }
            case LEFT: {
                localValues = TableJoiner.processLeftJoin(context, columnsLoaded, rawData, table, tableData);
                break;
            }
            case FULL: {
                localValues = TableJoiner.processFullJoin(context, columnsLoaded, rawData, table, tableData);
                break;
            }
            default: {
                localValues = TableJoiner.processInnerJoin(context, columnsLoaded, rawData, table, tableData);
            }
        }
        return localValues;
    }

    private static List<Object[]> processLeftJoin(Context context, List<Column> columnsLoaded, Collection<Object[]> rawData, PlanTableNode table, Collection<Object[]> tableData) throws SQLException {
        Object[] column = new Object[columnsLoaded.size()];
        ArrayList<Object[]> localValues = new ArrayList<Object[]>(127);
        for (Object[] cols : rawData) {
            System.arraycopy(cols, 0, column, 0, cols.length);
            boolean changed = false;
            for (Object[] newCols : tableData) {
                context.checkCancelState();
                System.arraycopy(newCols, 0, column, cols.length, newCols.length);
                if (table.getConditionalJoin() != null && !table.getConditionalJoin().evaluate(context, column, columnsLoaded)) continue;
                changed = true;
                localValues.add((Object[])column.clone());
            }
            if (changed) continue;
            Arrays.fill(column, cols.length, column.length, null);
            localValues.add((Object[])column.clone());
        }
        return localValues;
    }

    private static List<Object[]> processRightJoin(Context context, List<Column> columnsLoaded, Collection<Object[]> rawData, PlanTableNode table, Collection<Object[]> tableData) throws SQLException {
        Object[] column = new Object[columnsLoaded.size()];
        ArrayList<Object[]> localValues = new ArrayList<Object[]>(127);
        for (Object[] newCols : tableData) {
            System.arraycopy(newCols, 0, column, column.length - newCols.length, newCols.length);
            boolean changed = false;
            for (Object[] cols : rawData) {
                context.checkCancelState();
                System.arraycopy(cols, 0, column, 0, cols.length);
                if (table.getConditionalJoin() != null && !table.getConditionalJoin().evaluate(context, column, columnsLoaded)) continue;
                changed = true;
                localValues.add((Object[])column.clone());
            }
            if (changed) continue;
            Arrays.fill(column, 0, column.length - newCols.length, null);
            localValues.add((Object[])column.clone());
        }
        return localValues;
    }

    private static List<Object[]> processFullJoin(Context context, List<Column> columnsLoaded, Collection<Object[]> rawData, PlanTableNode table, Collection<Object[]> tableData) throws SQLException {
        Object[] column = new Object[columnsLoaded.size()];
        ArrayList<Object[]> localValues = new ArrayList<Object[]>(127);
        HashSet<Integer> inLeft = new HashSet<Integer>();
        for (Object[] cols : rawData) {
            System.arraycopy(cols, 0, column, 0, cols.length);
            boolean changed = false;
            int i = -1;
            for (Object[] newCols : tableData) {
                context.checkCancelState();
                ++i;
                System.arraycopy(newCols, 0, column, cols.length, newCols.length);
                if (table.getConditionalJoin() != null && !table.getConditionalJoin().evaluate(context, column, columnsLoaded)) continue;
                inLeft.add(i);
                changed = true;
                localValues.add((Object[])column.clone());
            }
            if (changed) continue;
            Arrays.fill(column, cols.length, column.length, null);
            localValues.add((Object[])column.clone());
        }
        Arrays.fill(column, 0, column.length, null);
        int i = 0;
        for (Object[] newCols : tableData) {
            context.checkCancelState();
            if (!inLeft.contains(i)) {
                System.arraycopy(newCols, 0, column, column.length - newCols.length, newCols.length);
                localValues.add((Object[])column.clone());
            }
            ++i;
        }
        return localValues;
    }

    private static Collection<Object[]> processInnerJoin(Context context, List<Column> columnsLoaded, Collection<Object[]> rawData, PlanTableNode table, Collection<Object[]> tableData) throws SQLException {
        int initialCapacity = table.getConditionalJoin() != null ? rawData.size() * tableData.size() : 127;
        if (columnsLoaded.isEmpty()) {
            return new FixedValueCollection<Object[]>(rawData.size() * tableData.size(), new Object[0]);
        }
        ArrayList<Object[]> localValues = new ArrayList<Object[]>(initialCapacity);
        Object[] column = new Object[columnsLoaded.size()];
        for (Object[] cols : rawData) {
            System.arraycopy(cols, 0, column, 0, cols.length);
            for (Object[] newCols : tableData) {
                context.checkCancelState();
                System.arraycopy(newCols, 0, column, cols.length, newCols.length);
                if (table.getConditionalJoin() != null && !table.getConditionalJoin().evaluate(context, column, columnsLoaded)) continue;
                localValues.add((Object[])column.clone());
            }
        }
        return localValues;
    }
}

