/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.plan;

import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.parser.nodes.AbstractConditionalNode;
import com.googlecode.paradox.parser.nodes.AsteriskNode;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.FunctionNode;
import com.googlecode.paradox.planner.nodes.ParameterNode;
import com.googlecode.paradox.planner.nodes.PlanTableNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.planner.nodes.join.ANDNode;
import com.googlecode.paradox.planner.nodes.join.AbstractJoinNode;
import com.googlecode.paradox.results.Column;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class SelectUtils {
    private SelectUtils() {
    }

    public static void addAndClause(PlanTableNode table, SQLNode clause) {
        if (table.getConditionalJoin() instanceof ANDNode) {
            table.getConditionalJoin().addChild(clause);
        } else if (table.getConditionalJoin() != null) {
            ANDNode andNode = new ANDNode(table.getConditionalJoin(), null);
            andNode.addChild(clause);
            table.setConditionalJoin(andNode);
        } else {
            table.setConditionalJoin((AbstractConditionalNode)clause);
        }
    }

    public static List<FunctionNode> getGroupingFunctions(Column column) {
        FunctionNode function = column.getFunction();
        if (function == null) {
            return Collections.emptyList();
        }
        return function.getGroupingNodes();
    }

    public static Set<Column> getConditionalFields(PlanTableNode table, AbstractConditionalNode condition) {
        if (condition != null) {
            return condition.getClauseFields().stream().filter(node -> table.isThis(node.getTableName())).map(table::findField).filter(Objects::nonNull).map(Column::new).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static AbstractConditionalNode joinClauses(AbstractConditionalNode node) {
        AbstractConditionalNode ret = node;
        if (node instanceof AbstractJoinNode) {
            List<SQLNode> children = node.getChildren();
            for (int loop = 0; loop < children.size(); ++loop) {
                children.set(loop, SelectUtils.joinClauses((AbstractConditionalNode)children.get(loop)));
            }
            while (ret instanceof AbstractJoinNode && ret.getChildren().size() <= 1) {
                if (ret.getChildren().isEmpty()) {
                    ret = null;
                    continue;
                }
                ret = (AbstractConditionalNode)ret.getChildren().get(0);
            }
        }
        return ret;
    }

    public static List<Column> getParadoxFields(FieldNode node, List<PlanTableNode> tables) throws ParadoxException {
        ArrayList<Column> ret = new ArrayList<Column>();
        if (node instanceof FunctionNode) {
            FunctionNode functionNode = (FunctionNode)node;
            ret.add(new Column(functionNode));
            for (FieldNode field : functionNode.getClauseFields()) {
                ret.addAll(SelectUtils.getParadoxFields(field, tables));
            }
        } else if (!(node instanceof ValueNode || node instanceof ParameterNode || node instanceof AsteriskNode)) {
            for (PlanTableNode table : tables) {
                if (node.getTableName() != null && !table.isThis(node.getTableName())) continue;
                node.setTable(table.getTable());
                ret.addAll(Arrays.stream(table.getTable().getFields()).filter(f -> f.getName().equalsIgnoreCase(node.getName())).map(Column::new).collect(Collectors.toList()));
            }
            if (ret.isEmpty()) {
                throw new ParadoxException(ParadoxException.Error.INVALID_COLUMN, node.getPosition(), node.toString());
            }
            if (ret.size() > 1) {
                throw new ParadoxException(ParadoxException.Error.COLUMN_AMBIGUOUS_DEFINED, node.getPosition(), node.toString());
            }
        }
        return ret;
    }
}

