/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.plan;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.parser.nodes.AbstractConditionalNode;
import com.googlecode.paradox.parser.nodes.AsteriskNode;
import com.googlecode.paradox.parser.nodes.JoinType;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.parser.nodes.SelectNode;
import com.googlecode.paradox.parser.nodes.TableNode;
import com.googlecode.paradox.planner.FieldValueUtils;
import com.googlecode.paradox.planner.context.SelectContext;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.FunctionNode;
import com.googlecode.paradox.planner.nodes.GroupByNode;
import com.googlecode.paradox.planner.nodes.OrderByNode;
import com.googlecode.paradox.planner.nodes.ParameterNode;
import com.googlecode.paradox.planner.nodes.PlanTableNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.planner.nodes.join.ANDNode;
import com.googlecode.paradox.planner.nodes.join.ORNode;
import com.googlecode.paradox.planner.plan.Plan;
import com.googlecode.paradox.planner.plan.SelectUtils;
import com.googlecode.paradox.planner.plan.TableJoiner;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.utils.FunctionalUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SelectPlan
implements Plan<List<Object[]>, SelectContext> {
    private final List<Column> columns;
    private final List<Column> columnsFromFunctions = new ArrayList<Column>();
    private final List<PlanTableNode> tables;
    private final boolean distinct;
    private final OrderByNode orderBy;
    private final GroupByNode groupBy;
    private AbstractConditionalNode condition;
    private final int parameterCount;
    private final Integer limit;
    private final Integer offset;

    public SelectPlan(ConnectionInfo connectionInfo, SelectNode statement) throws SQLException {
        this.condition = statement.getCondition();
        this.distinct = statement.isDistinct();
        this.parameterCount = statement.getParameterCount();
        this.limit = statement.getLimit();
        this.offset = statement.getOffset();
        this.tables = statement.getTables().stream().map(FunctionalUtils.functionWrapper(table -> new PlanTableNode(connectionInfo, (TableNode)table))).collect(Collectors.toList());
        this.columns = this.parseColumns(statement);
        this.groupBy = new GroupByNode(statement, this.tables, this.columns);
        this.orderBy = new OrderByNode(statement, this.tables, this.columns, connectionInfo, this.groupBy.isGroupBy());
        if (this.columns.isEmpty()) {
            throw new ParadoxSyntaxErrorException(SyntaxError.EMPTY_COLUMN_LIST);
        }
        for (PlanTableNode table2 : this.tables) {
            table2.addColumns(this.columns);
            table2.addColumns(this.columnsFromFunctions);
            table2.addColumns(this.groupBy.getColumns());
            table2.addColumns(this.orderBy.getColumns());
            table2.addColumns(SelectUtils.getConditionalFields(table2, this.condition));
            for (PlanTableNode tableToField : this.tables) {
                table2.addColumns(SelectUtils.getConditionalFields(table2, tableToField.getConditionalJoin()));
            }
        }
    }

    @Override
    public void optimize() {
        if (this.optimizeConditions(this.condition)) {
            this.condition = null;
        }
        this.condition = SelectUtils.joinClauses(this.condition);
        for (PlanTableNode table : this.tables) {
            table.setConditionalJoin(SelectUtils.joinClauses(table.getConditionalJoin()));
        }
    }

    @Override
    public SelectContext createContext(ConnectionInfo connectionInfo, Object[] parameters, ParadoxType[] parameterTypes) {
        return new SelectContext(connectionInfo, parameters, parameterTypes);
    }

    private List<Column> parseColumns(SelectNode statement) throws SQLException {
        ArrayList<Column> ret = new ArrayList<Column>();
        for (SQLNode field : statement.getFields()) {
            if (field instanceof AsteriskNode) {
                if (this.tables.isEmpty()) {
                    throw new ParadoxSyntaxErrorException(SyntaxError.ASTERISK_WITHOUT_TABLE, field.getPosition());
                }
                ret.addAll(this.parseAsterisk((AsteriskNode)field));
                continue;
            }
            ret.addAll(this.processColumn((FieldNode)field));
        }
        for (int i = 0; i < ret.size(); ++i) {
            ((Column)ret.get(i)).setIndex(i);
        }
        return ret;
    }

    private List<Column> parseAsterisk(AsteriskNode field) throws SQLException {
        if (field.getTableName() != null) {
            List tablesFound = this.tables.stream().filter(t -> t.isThis(field.getTableName())).map(PlanTableNode::getTable).collect(Collectors.toList());
            if (tablesFound.isEmpty()) {
                throw new ParadoxDataException(DataError.TABLE_NOT_FOUND, field.getPosition(), field.getTableName());
            }
            if (tablesFound.size() > 1) {
                throw new ParadoxException(ParadoxException.Error.TABLE_AMBIGUOUS_DEFINED, field.getPosition(), field.getTableName());
            }
            return Arrays.stream(((Table)tablesFound.get(0)).getFields()).map(Column::new).collect(Collectors.toList());
        }
        return this.tables.stream().map(PlanTableNode::getTable).map(Table::getFields).flatMap(Arrays::stream).map(Column::new).collect(Collectors.toList());
    }

    private int getTableIndex(Table table) {
        int index = -1;
        for (int i = 0; i < this.tables.size(); ++i) {
            if (!this.tables.get(i).getTable().equals(table)) continue;
            index = i;
            break;
        }
        return index;
    }

    private PlanTableNode getPlanTable(Table table) {
        return this.tables.stream().filter(t -> table.equals(t.getTable())).findFirst().orElse(null);
    }

    private List<Column> processColumn(FieldNode node) throws SQLException {
        List<Column> ret;
        if (node instanceof ValueNode) {
            ret = Collections.singletonList(new Column((ValueNode)node));
        } else if (node instanceof ParameterNode) {
            ret = Collections.singletonList(new Column((ParameterNode)node));
        } else if (node instanceof FunctionNode) {
            List<Column> columnsToProcess = SelectUtils.getParadoxFields(node, this.tables);
            Column column2 = columnsToProcess.get(0);
            column2.setName(node.getAlias());
            ret = Collections.singletonList(column2);
            this.columnsFromFunctions.addAll(columnsToProcess);
        } else {
            ret = SelectUtils.getParadoxFields(node, this.tables);
            ret.forEach(column -> column.setName(node.getAlias()));
        }
        return ret;
    }

    private boolean optimizeConditions(SQLNode node) {
        boolean ret = false;
        if (node instanceof ANDNode) {
            ANDNode andNode = (ANDNode)node;
            andNode.getChildren().removeIf(this::optimizeConditions);
            ret = node.getClauseFields().isEmpty();
        } else if (node != null && !(node instanceof ORNode)) {
            ArrayList conditionalFields = new ArrayList();
            Set<FieldNode> fields = node.getClauseFields();
            fields.forEach(fn -> {
                for (PlanTableNode table : this.tables) {
                    if (!table.isThis(fn.getTableName())) continue;
                    conditionalFields.addAll(Arrays.stream(table.getTable().getFields()).filter(f -> f.getName().equalsIgnoreCase(fn.getName())).collect(Collectors.toSet()));
                }
            });
            if (conditionalFields.size() == 1) {
                Table paradoxTable = ((Field)conditionalFields.get(0)).getTable();
                PlanTableNode planTableNode = this.getPlanTable(paradoxTable);
                if (planTableNode != null && (planTableNode.getJoinType() == JoinType.CROSS || planTableNode.getJoinType() == JoinType.INNER)) {
                    SelectUtils.addAndClause(planTableNode, node);
                    ret = true;
                }
            } else if (conditionalFields.size() > 1) {
                Table paradoxTable1 = ((Field)conditionalFields.get(0)).getTable();
                Table paradoxTable2 = ((Field)conditionalFields.get(1)).getTable();
                int index1 = this.getTableIndex(paradoxTable1);
                int index2 = this.getTableIndex(paradoxTable2);
                if (index1 != -1 && index2 != -1) {
                    int lastIndex = Math.max(index1, index2);
                    SelectUtils.addAndClause(this.tables.get(lastIndex), node);
                    ret = true;
                }
            }
        }
        return ret;
    }

    @Override
    public List<Object[]> execute(SelectContext context) throws SQLException {
        if (this.columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Column> columnsLoaded = new ArrayList<Column>();
        Collection<Object> rawData = Collections.emptyList();
        for (int tableIndex = 0; tableIndex < this.tables.size(); ++tableIndex) {
            PlanTableNode table = this.tables.get(tableIndex);
            context.checkCancelState();
            Collection<Object[]> tableData = table.load();
            columnsLoaded.addAll(table.getColumns());
            if (table.getConditionalJoin() != null) {
                table.getConditionalJoin().setFieldIndexes(columnsLoaded, this.tables);
            }
            if (tableIndex == 0) {
                if (table.getConditionalJoin() != null) {
                    rawData = tableData.stream().filter(context.getCancelPredicate()).filter(FunctionalUtils.predicateWrapper(tableRow -> table.getConditionalJoin().evaluate(context, (Object[])tableRow, (List<Column>)columnsLoaded))).collect(Collectors.toList());
                    continue;
                }
                rawData = tableData;
                continue;
            }
            rawData = TableJoiner.processJoinByType(context, columnsLoaded, rawData, table, tableData);
        }
        if (this.tables.isEmpty()) {
            Object[] row = new Object[this.columns.size()];
            for (int i = 0; i < row.length; ++i) {
                row[i] = this.columns.get(i).getValue();
            }
            rawData = Collections.singleton(row);
        } else if (rawData.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.canDoFastCount()) {
            Object[] row = new Object[]{rawData.size()};
            return Collections.singletonList(row);
        }
        this.processIndexes(columnsLoaded);
        this.processFunctionIndexes(columnsLoaded);
        this.columns.stream().filter(column -> column.getParameter() != null).forEach(column -> column.setType(context.getParameterTypes()[column.getParameter().getParameterIndex()]));
        int[] mapColumns = this.mapColumnIndexes(columnsLoaded);
        return this.filter(context, rawData, mapColumns, columnsLoaded);
    }

    private boolean canDoFastCount() {
        if (!this.groupBy.getColumns().isEmpty() || this.columns.size() != 1) {
            return false;
        }
        Column column = this.columns.get(0);
        if (column.getFunction() == null || !column.getFunction().isCount()) {
            return false;
        }
        Set<FieldNode> fields = column.getFunction().getClauseFields();
        FieldNode field = fields.iterator().next();
        return (field instanceof AsteriskNode || field instanceof ValueNode) && !"null".equals(field.getName());
    }

    private void processIndexes(List<Column> columns) throws SQLException {
        if (this.condition != null) {
            this.condition.setFieldIndexes(columns, this.tables);
        }
        for (PlanTableNode table : this.tables) {
            if (table.getConditionalJoin() == null) continue;
            table.getConditionalJoin().setFieldIndexes(columns, this.tables);
        }
    }

    private void processFunctionIndexes(List<Column> columnsLoaded) throws SQLException {
        for (Column column : this.columns) {
            if (column.getFunction() == null) continue;
            FieldValueUtils.setFunctionIndexes(column.getFunction(), columnsLoaded, this.tables);
        }
    }

    private int[] mapColumnIndexes(List<Column> loadedColumns) {
        int[] mapColumns = new int[this.columns.size()];
        Arrays.fill(mapColumns, -1);
        block0: for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            for (int loop = 0; loop < loadedColumns.size(); ++loop) {
                if (!loadedColumns.get(loop).getField().equals(column.getField())) continue;
                mapColumns[i] = loop;
                continue block0;
            }
        }
        return mapColumns;
    }

    private Object[] mapRow(SelectContext context, Object[] tableRow, int[] mapColumns, List<Column> columnsLoaded) throws SQLException {
        Object[] finalRow = new Object[mapColumns.length];
        for (int i = 0; i < mapColumns.length; ++i) {
            int index = mapColumns[i];
            if (index != -1) {
                finalRow[i] = tableRow[index];
                continue;
            }
            ParameterNode parameterNode = this.columns.get(i).getParameter();
            FunctionNode functionNode = this.columns.get(i).getFunction();
            if (parameterNode != null) {
                finalRow[i] = context.getParameters()[parameterNode.getParameterIndex()];
                continue;
            }
            if (functionNode == null) {
                finalRow[i] = this.columns.get(i).getValue();
                continue;
            }
            if (this.columns.get(i).isSecondPass()) continue;
            finalRow[i] = functionNode.execute(context, tableRow, columnsLoaded);
            this.columns.get(i).setType(functionNode.getType());
        }
        return finalRow;
    }

    private List<Object[]> filter(SelectContext context, Collection<Object[]> rowValues, int[] mapColumns, List<Column> columnsLoaded) {
        Stream<Object[]> stream = rowValues.stream().filter(context.getCancelPredicate());
        if (this.condition != null) {
            stream = stream.filter(FunctionalUtils.predicateWrapper(tableRow -> this.condition.evaluate(context, (Object[])tableRow, columnsLoaded)));
        }
        stream = stream.map(FunctionalUtils.functionWrapper(tableRow -> this.mapRow(context, (Object[])tableRow, mapColumns, columnsLoaded)));
        stream = this.groupBy.processStream(context, stream, this.columns);
        stream = this.orderBy.processStream(stream, this.columns, context.getConnectionInfo());
        if (this.distinct) {
            stream = stream.filter(FunctionalUtils.distinctByKey(this.columns, context.getConnectionInfo()));
        }
        if (this.offset != null) {
            stream = stream.skip(this.offset.intValue());
        }
        if (this.limit != null) {
            stream = stream.limit(this.limit.intValue());
        }
        if (context.getMaxRows() != 0) {
            stream = stream.limit(context.getMaxRows());
        }
        return stream.collect(Collectors.toList());
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public AbstractConditionalNode getCondition() {
        return this.condition;
    }

    public List<PlanTableNode> getTables() {
        return this.tables;
    }

    public GroupByNode getGroupBy() {
        return this.groupBy;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectPlan that = (SelectPlan)o;
        return this.distinct == that.distinct && Objects.equals(this.columns, that.columns) && Objects.equals(this.tables, that.tables) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.tables, this.distinct, this.condition);
    }
}

