/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.nodes.join;

import com.googlecode.paradox.parser.ScannerPosition;
import com.googlecode.paradox.parser.nodes.AbstractConditionalNode;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.PlanTableNode;
import com.googlecode.paradox.results.Column;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public abstract class AbstractJoinNode
extends AbstractConditionalNode {
    public AbstractJoinNode(String fieldName, SQLNode child, ScannerPosition position) {
        super(fieldName, position);
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public final void setFieldIndexes(List<Column> columns, List<PlanTableNode> tables) throws SQLException {
        for (SQLNode node : this.children) {
            ((AbstractConditionalNode)node).setFieldIndexes(columns, tables);
        }
    }

    @Override
    public final Set<FieldNode> getClauseFields() {
        Set<FieldNode> nodes = super.getClauseFields();
        for (SQLNode node : this.children) {
            nodes.addAll(node.getClauseFields());
        }
        return nodes;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (SQLNode node : this.children) {
            if (first) {
                builder.append(" (");
                first = false;
            } else {
                builder.append(" ");
                builder.append(this.name);
                builder.append(" ");
            }
            builder.append(node.toString());
        }
        builder.append(") ");
        return builder.toString();
    }
}

