/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.nodes.comparable;

import com.googlecode.paradox.parser.ScannerPosition;
import com.googlecode.paradox.planner.FieldValueUtils;
import com.googlecode.paradox.planner.context.Context;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.planner.nodes.comparable.AbstractComparableNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.rowset.ValuesComparator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class InNode
extends AbstractComparableNode {
    private final List<ValueNode> values = new ArrayList<ValueNode>();

    public InNode(FieldNode field, ScannerPosition position) {
        super("in", field, null, position);
    }

    public void addField(ValueNode value) {
        this.values.add(value);
    }

    public List<ValueNode> getValues() {
        return this.values;
    }

    @Override
    public boolean evaluate(Context context, Object[] row, List<Column> columnsLoaded) throws SQLException {
        Object value1 = FieldValueUtils.getValue(context, row, this.field, columnsLoaded);
        for (ValueNode value : this.values) {
            String value2 = value.getName();
            if (!ValuesComparator.equals(value1, value2, context.getConnectionInfo())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.field.toString());
        builder.append(" IN (");
        for (int i = 0; i < this.values.size(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(this.values.get(i).toString());
        }
        builder.append(")");
        return builder.toString();
    }
}

