/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.nodes.comparable;

import com.googlecode.paradox.parser.ScannerPosition;
import com.googlecode.paradox.planner.FieldValueUtils;
import com.googlecode.paradox.planner.context.Context;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.comparable.AbstractComparableNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.rowset.ValuesComparator;
import java.sql.SQLException;
import java.util.List;

public final class BetweenNode
extends AbstractComparableNode {
    private final FieldNode first;

    public BetweenNode(FieldNode field, FieldNode first, FieldNode last, ScannerPosition position) {
        super("BETWEEN", field, last, position);
        this.first = first;
    }

    @Override
    public String toString() {
        return this.field + " BETWEEN " + this.first + " AND " + this.last;
    }

    @Override
    public boolean evaluate(Context context, Object[] row, List<Column> columnsLoaded) throws SQLException {
        Object value1 = FieldValueUtils.getValue(context, row, this.field, columnsLoaded);
        Object value2 = FieldValueUtils.getValue(context, row, this.first, columnsLoaded);
        Object value3 = FieldValueUtils.getValue(context, row, this.last, columnsLoaded);
        return ValuesComparator.compare(value1, value2, i -> i >= 0, context.getConnectionInfo()) && ValuesComparator.compare(value1, value3, i -> i <= 0, context.getConnectionInfo());
    }
}

