/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.nodes;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.parser.nodes.AbstractConditionalNode;
import com.googlecode.paradox.parser.nodes.JoinNode;
import com.googlecode.paradox.parser.nodes.JoinType;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.parser.nodes.TableNode;
import com.googlecode.paradox.planner.collections.FixedValueCollection;
import com.googlecode.paradox.results.Column;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class PlanTableNode {
    private String alias;
    private final Table table;
    private final JoinType joinType;
    private AbstractConditionalNode conditionalJoin;
    private final Set<Column> columns = new HashSet<Column>();

    public PlanTableNode(ConnectionInfo connectionInfo, TableNode table) throws SQLException {
        Schema schema = table.getSchemaName() == null ? connectionInfo.getCurrentSchema() : connectionInfo.getSchema(connectionInfo.getCatalog(), table.getSchemaName());
        String tableName = table.getName();
        this.table = schema.findTable(connectionInfo, tableName);
        if (this.table == null) {
            throw new ParadoxDataException(DataError.TABLE_NOT_FOUND, table.getPosition(), tableName);
        }
        this.alias = table.getAlias();
        if (table instanceof JoinNode) {
            JoinNode join = (JoinNode)table;
            this.conditionalJoin = join.getCondition();
            this.joinType = join.getJoinType();
        } else {
            this.conditionalJoin = null;
            this.joinType = JoinType.INNER;
        }
    }

    public Field findField(SQLNode field) {
        return Arrays.stream(this.table.getFields()).filter(f -> f.getName().equalsIgnoreCase(field.getName())).findFirst().orElse(null);
    }

    public void addColumns(Collection<Column> columns) {
        columns.stream().filter(c -> c.isThis(this.table)).forEach(this.columns::add);
    }

    public Collection<Object[]> load() throws SQLException {
        if (this.columns.isEmpty()) {
            return new FixedValueCollection<Object[]>(this.table.getRowCount(), new Object[0]);
        }
        return this.table.load((Field[])this.columns.stream().map(Column::getField).toArray(Field[]::new));
    }

    public Set<Column> getColumns() {
        return this.columns;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Table getTable() {
        return this.table;
    }

    public boolean isThis(String aliasOrName) {
        if (aliasOrName == null) {
            return true;
        }
        return aliasOrName.equalsIgnoreCase(this.table.getName()) || aliasOrName.equalsIgnoreCase(this.alias);
    }

    public String toString() {
        if (this.alias != null) {
            return this.table.getName() + " as " + this.alias;
        }
        return this.table.getName();
    }

    public AbstractConditionalNode getConditionalJoin() {
        return this.conditionalJoin;
    }

    public void setConditionalJoin(AbstractConditionalNode conditionalJoin) {
        this.conditionalJoin = conditionalJoin;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }
}

