/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.nodes;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.parser.nodes.SelectNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.PlanTableNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.planner.plan.SelectUtils;
import com.googlecode.paradox.planner.sorting.OrderByComparator;
import com.googlecode.paradox.planner.sorting.OrderType;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OrderByNode {
    private final List<Column> columns = new ArrayList<Column>();
    private final List<OrderType> types = new ArrayList<OrderType>();

    public OrderByNode(SelectNode selectNode, List<PlanTableNode> tables, List<Column> selectColumns, ConnectionInfo connectionInfo, boolean groupBy) throws SQLException {
        List columnsFound;
        for (int i = 0; i < selectNode.getOrder().size(); ++i) {
            FieldNode field = selectNode.getOrder().get(i);
            OrderType type = selectNode.getOrderTypes().get(i);
            if (field instanceof ValueNode) {
                int index = ValuesConverter.getInteger(field.getName(), connectionInfo);
                if (index > selectColumns.size()) {
                    throw new ParadoxException(ParadoxException.Error.INVALID_COLUMN_INDEX, index);
                }
                this.processOrderColumn(selectColumns.get(index - 1), type, selectColumns);
                continue;
            }
            SelectUtils.getParadoxFields(field, tables).forEach(c -> this.processOrderColumn((Column)c, type, selectColumns));
        }
        if (groupBy && !this.columns.isEmpty() && !(columnsFound = selectColumns.stream().filter(c -> !c.isHidden()).collect(Collectors.toList())).containsAll(selectColumns)) {
            throw new ParadoxSyntaxErrorException(SyntaxError.ORDER_BY_NOT_IN_GROUP_BY);
        }
    }

    private void processOrderColumn(Column column, OrderType type, List<Column> selectColumns) {
        this.columns.add(column);
        this.types.add(type);
        if (!selectColumns.contains(column)) {
            column.setHidden(true);
            selectColumns.add(column);
        }
    }

    public Stream<Object[]> processStream(Stream<Object[]> stream, List<Column> selectColumns, ConnectionInfo connectionInfo) {
        if (this.columns.isEmpty()) {
            return stream;
        }
        int[] mapColumns = new int[this.columns.size()];
        Arrays.fill(mapColumns, -1);
        block0: for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            mapColumns[i] = column.getIndex();
            for (int loop = 0; loop < selectColumns.size(); ++loop) {
                if (!selectColumns.get(loop).equals(column)) continue;
                mapColumns[i] = loop;
                continue block0;
            }
        }
        Comparator<Object[]> comparator = null;
        for (int i = 0; i < mapColumns.length; ++i) {
            int index = mapColumns[i];
            OrderByComparator orderByComparator = new OrderByComparator(index, this.types.get(i), connectionInfo);
            comparator = comparator == null ? orderByComparator : comparator.thenComparing(orderByComparator);
        }
        return stream.sorted(Objects.requireNonNull(comparator));
    }

    public Set<Column> getColumns(ParadoxTable table) {
        return this.columns.stream().filter(c -> c.isThis(table)).collect(Collectors.toSet());
    }

    public List<Column> getColumns() {
        return this.columns;
    }
}

