/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.nodes;

import com.googlecode.paradox.exceptions.ParadoxNotSupportedException;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.parser.nodes.SelectNode;
import com.googlecode.paradox.planner.context.SelectContext;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.FunctionNode;
import com.googlecode.paradox.planner.nodes.ParameterNode;
import com.googlecode.paradox.planner.nodes.PlanTableNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.planner.plan.SelectUtils;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.utils.FunctionalUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroupByNode {
    private final int[] functionColumns;
    private final int[] groupColumns;
    private final List<Column> columns = new ArrayList<Column>();
    private final boolean groupBy;

    public GroupByNode(SelectNode statement, List<PlanTableNode> tables, List<Column> columns) throws SQLException {
        for (FieldNode field : statement.getGroups()) {
            if (field instanceof ParameterNode) {
                throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED, field.getPosition());
            }
            if (field instanceof ValueNode) {
                this.addGroupColumn(new Column((ValueNode)field), columns);
                continue;
            }
            this.addGroupColumn(field, tables, columns);
        }
        boolean bl = this.groupBy = columns.stream().map(Column::getFunction).filter(Objects::nonNull).anyMatch(FunctionNode::isGrouping) || !this.columns.isEmpty();
        if (this.groupBy) {
            HashSet<Column> groupColumnsToCheck = new HashSet<Column>(this.columns);
            List fields = columns.stream().filter(c -> c.getFunction() == null || !c.getFunction().isGrouping()).filter(c -> !groupColumnsToCheck.remove(c)).collect(Collectors.toList());
            if (!fields.isEmpty()) {
                throw new ParadoxSyntaxErrorException(SyntaxError.NOT_GROUP_BY);
            }
        }
        List columnList = columns.stream().map(SelectUtils::getGroupingFunctions).flatMap(Collection::stream).map(Column::new).collect(Collectors.toList());
        for (Column column : columnList) {
            int index = columns.indexOf(column);
            if (index < 0) {
                column.setHidden(true);
                column.getFunction().setIndex(columns.size());
                columns.add(column);
                continue;
            }
            column.getFunction().setIndex(index);
        }
        this.functionColumns = columns.stream().map(Column::getFunction).filter(Objects::nonNull).filter(FunctionNode::isGrouping).filter(f -> !f.isSecondPass()).mapToInt(FieldNode::getIndex).toArray();
        HashSet<Column> columnsToCheck = new HashSet<Column>(this.columns);
        this.groupColumns = columns.stream().filter(c -> c.getFunction() == null || !c.getFunction().isGrouping()).filter(c -> !c.isHidden() || columnsToCheck.remove(c)).mapToInt(Column::getIndex).toArray();
    }

    private void addGroupColumn(FieldNode node, List<PlanTableNode> tables, List<Column> columns) throws SQLException {
        SelectUtils.getParadoxFields(node, tables).forEach(field -> this.addGroupColumn((Column)field, columns));
    }

    private void addGroupColumn(Column column, List<Column> columns) {
        this.columns.add(column);
        if (!columns.contains(column)) {
            column.setHidden(true);
            columns.add(column);
        }
    }

    public Stream<Object[]> processStream(SelectContext context, Stream<Object[]> stream, List<Column> columns) {
        if (!this.groupBy) {
            return stream;
        }
        return stream.filter(FunctionalUtils.groupingByKeys(this.functionColumns, this.groupColumns, context.getConnectionInfo())).collect(Collectors.toList()).stream().filter(context.getCancelPredicate()).map(FunctionalUtils.functionWrapper(FunctionalUtils.removeGrouping(context, this.functionColumns, columns)));
    }

    public Set<Column> getColumns(ParadoxTable table) {
        return this.columns.stream().filter(c -> c.isThis(table)).collect(Collectors.toSet());
    }

    public boolean isGroupBy() {
        return this.groupBy;
    }

    public List<Column> getColumns() {
        return this.columns;
    }
}

