/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.nodes;

import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.AbstractFunction;
import com.googlecode.paradox.function.FunctionFactory;
import com.googlecode.paradox.function.aggregate.CountFunction;
import com.googlecode.paradox.parser.ScannerPosition;
import com.googlecode.paradox.parser.nodes.AsteriskNode;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.FieldValueUtils;
import com.googlecode.paradox.planner.context.Context;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.ParameterNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FunctionNode
extends FieldNode {
    private final List<SQLNode> parameters = new ArrayList<SQLNode>();
    private final AbstractFunction function;
    private FieldNode[] fields;

    public FunctionNode(String name, ScannerPosition position) throws ParadoxSyntaxErrorException {
        super(null, name, position);
        this.function = FunctionFactory.getByName(name);
        if (this.function == null) {
            throw new ParadoxSyntaxErrorException(SyntaxError.FUNCTION_NOT_FOUND, position, name);
        }
    }

    public void validate(ScannerPosition position) throws ParadoxSyntaxErrorException {
        int parameterCount = this.function.getParameterCount();
        int maxParameterCount = this.function.getMaxParameterCount();
        if (this.function.isVariableParameters()) {
            if (this.parameters.size() < parameterCount) {
                throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_COUNT_MINIMUM, position, parameterCount);
            }
            if (maxParameterCount != 0 && maxParameterCount < this.parameters.size()) {
                throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_COUNT_MAXIMUM, position, this.parameters.size(), maxParameterCount);
            }
        } else if (parameterCount != this.parameters.size()) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_COUNT, position, parameterCount);
        }
        this.function.validate(this.parameters);
    }

    @Override
    public Set<FieldNode> getClauseFields() {
        if (this.fields == null) {
            this.fields = (FieldNode[])this.parameters.stream().map(field -> {
                if (field instanceof FieldNode) {
                    return (FieldNode)field;
                }
                return null;
            }).toArray(FieldNode[]::new);
        }
        return Arrays.stream(this.fields).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public List<SQLNode> getParameters() {
        return this.parameters;
    }

    public boolean isGrouping() {
        List<FunctionNode> functionNodes = this.getGroupingNodes();
        return this.function.isGrouping() || !functionNodes.isEmpty();
    }

    public boolean isSecondPass() {
        List<FunctionNode> functionNodes = this.getGroupingNodes();
        return !this.function.isGrouping() && !functionNodes.isEmpty();
    }

    public void addParameter(SQLNode parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name);
        buffer.append("(");
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.parameters.get(i));
        }
        buffer.append(")");
        return buffer.toString();
    }

    public ParadoxType getType() {
        return this.function.getFieldType();
    }

    @Override
    public String getAlias() {
        if (this.alias == null || !this.alias.equals(this.name)) {
            return super.getAlias();
        }
        return this.toString();
    }

    public Object execute(Context context, Object[] row, List<Column> loadedColumns) throws SQLException {
        Object[] values = new Object[this.parameters.size()];
        ParadoxType[] types = new ParadoxType[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            SQLNode param = this.parameters.get(i);
            types[i] = ParadoxType.NULL;
            if (param instanceof ValueNode) {
                values[i] = param.getName();
                types[i] = ((ValueNode)param).getType();
                continue;
            }
            if (param instanceof ParameterNode) {
                values[i] = FieldValueUtils.getValue(context, row, (FieldNode)param, loadedColumns);
                types[i] = context.getParameterTypes()[((ParameterNode)param).getParameterIndex()];
                continue;
            }
            if (param instanceof FunctionNode) {
                FunctionNode functionNode = (FunctionNode)param;
                if (functionNode.isGrouping()) {
                    int index = FunctionNode.getIndex(loadedColumns, functionNode);
                    values[i] = row[index];
                    types[i] = loadedColumns.get(index).getType();
                    continue;
                }
                values[i] = functionNode.execute(context, row, loadedColumns);
                types[i] = functionNode.getType();
                continue;
            }
            if (param instanceof AsteriskNode) {
                values[i] = param;
                types[i] = ParadoxType.NULL;
                continue;
            }
            values[i] = FieldValueUtils.getValue(context, row, (FieldNode)param, loadedColumns);
            types[i] = loadedColumns.get(((FieldNode)param).getIndex()).getType();
        }
        if (Stream.of(this.function.getColumns()).filter(c -> c.getColumnType() == 1 && !c.isNullable()).anyMatch(c -> values[c.getIndex() - 1] == null)) {
            return null;
        }
        return this.function.execute(context.getConnectionInfo(), values, types, this.fields);
    }

    private static int getIndex(List<Column> loadedColumns, FunctionNode functionNode) throws ParadoxSyntaxErrorException {
        int index = -1;
        for (int l = 0; l < loadedColumns.size(); ++l) {
            if (!functionNode.equals(loadedColumns.get(l).getFunction())) continue;
            index = l;
            break;
        }
        if (index == -1) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_AGGREGATE_FUNCTION, functionNode.getName());
        }
        return index;
    }

    public List<FunctionNode> getGroupingNodes() {
        ArrayList<FunctionNode> ret = new ArrayList<FunctionNode>();
        if (this.function.isGrouping()) {
            ret.add(this);
        }
        for (SQLNode node : this.parameters) {
            if (!(node instanceof FunctionNode)) continue;
            ret.addAll(((FunctionNode)node).getGroupingNodes());
        }
        return ret;
    }

    public boolean isCount() {
        return this.function instanceof CountFunction;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionNode that = (FunctionNode)o;
        return Objects.deepEquals(this.parameters, that.parameters) && Objects.equals(this.function, that.function);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parameters, this.function);
    }
}

