/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.nodes;

import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.parser.ScannerPosition;
import com.googlecode.paradox.parser.nodes.SQLNode;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class FieldNode
extends SQLNode {
    protected final String tableName;
    private int index = -1;
    private Table table;

    public FieldNode(String tableName, String fieldName, ScannerPosition position) {
        super(fieldName, position);
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.tableName != null) {
            builder.append(this.tableName);
            builder.append('.');
        }
        builder.append(this.name);
        if (this.alias != null && !this.getName().equals(this.alias)) {
            builder.append(" AS ");
            builder.append(this.alias);
        }
        if (this.index != -1) {
            builder.append("[");
            builder.append(this.index);
            builder.append("]");
        }
        return builder.toString();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldNode fieldNode = (FieldNode)o;
        return Objects.equals(this.tableName, fieldNode.tableName) && Objects.equals(this.alias, fieldNode.alias) && Objects.equals(this.name, fieldNode.name);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.alias, this.name);
    }

    @Override
    public Set<FieldNode> getClauseFields() {
        return Collections.singleton(this);
    }
}

