/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.context;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.exceptions.ParadoxNotSupportedException;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.utils.FunctionalUtils;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.function.Predicate;

public class Context {
    protected boolean cancelled;
    private final ConnectionInfo connectionInfo;
    private final Object[] parameters;
    private final ParadoxType[] parameterTypes;

    protected Context(ConnectionInfo connectionInfo, Object[] parameters, ParadoxType[] parameterTypes) {
        this.connectionInfo = connectionInfo;
        this.parameters = parameters;
        this.parameterTypes = parameterTypes;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public ParadoxType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Locale getLocale() {
        return this.connectionInfo.getLocale();
    }

    public void cancel() throws SQLFeatureNotSupportedException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.CANCEL_NOT_SUPPORTED);
    }

    public <T> Predicate<T> getCancelPredicate() {
        return FunctionalUtils.predicateWrapper(obj -> this.checkCancelState());
    }

    public boolean checkCancelState() throws SQLException {
        if (this.cancelled) {
            throw new ParadoxException(ParadoxException.Error.OPERATION_CANCELLED);
        }
        return true;
    }
}

