/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FixedValueCollection<T>
implements Collection<T> {
    private int size;
    private final T value;

    public FixedValueCollection(int size, T value) {
        this.size = size;
        this.value = value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new EmptyIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.size];
        Arrays.fill(ret, this.value);
        return ret;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        Object[] ret = a;
        if (a.length != this.size) {
            ret = Arrays.copyOf(a, this.size);
        }
        Arrays.fill(ret, this.value);
        return ret;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    private class EmptyIterator
    implements Iterator<T> {
        private int current = -1;

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current + 1 < FixedValueCollection.this.size;
        }

        @Override
        public T next() {
            if (this.current + 1 >= FixedValueCollection.this.size) {
                throw new NoSuchElementException();
            }
            ++this.current;
            return FixedValueCollection.this.value;
        }
    }
}

