/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.planner;

import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.parser.nodes.AsteriskNode;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.context.Context;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.FunctionNode;
import com.googlecode.paradox.planner.nodes.ParameterNode;
import com.googlecode.paradox.planner.nodes.PlanTableNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public final class FieldValueUtils {
    private FieldValueUtils() {
    }

    public static ParadoxType getSqlType(Object[] values, ParadoxType[] types) throws ParadoxSyntaxErrorException {
        if (types.length > 0) {
            ParadoxType current = ParadoxType.NULL;
            for (ParadoxType type : types) {
                if (current == ParadoxType.NULL) {
                    current = type;
                }
                if (current == ParadoxType.NULL || type == ParadoxType.NULL || current.getSQLType() == type.getSQLType()) continue;
                throw new ParadoxSyntaxErrorException(SyntaxError.INCONSISTENT_DATA_TYPE, current.name(), type.name());
            }
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            return types[i];
        }
        return ParadoxType.NULL;
    }

    public static void setFieldIndex(FieldNode field, List<Column> columns, Collection<PlanTableNode> tables) throws SQLException {
        if (field == null || field instanceof ValueNode || field instanceof ParameterNode || field instanceof AsteriskNode) {
            return;
        }
        if (field instanceof FunctionNode) {
            FieldValueUtils.setFunctionIndexes(field, columns, tables);
            return;
        }
        String tableName = tables.stream().filter(t -> t.getAlias().equalsIgnoreCase(field.getTableName())).map(PlanTableNode::getTable).map(Table::getName).findFirst().orElse(field.getTableName());
        int index = -1;
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (tableName != null && !tableName.equalsIgnoreCase(column.getField().getTable().getName()) || !column.getField().getName().equalsIgnoreCase(field.getName())) continue;
            if (index != -1) {
                throw new ParadoxException(ParadoxException.Error.COLUMN_AMBIGUOUS_DEFINED, field.toString());
            }
            index = i;
        }
        if (index == -1) {
            throw new ParadoxException(ParadoxException.Error.INVALID_COLUMN, field.toString());
        }
        field.setIndex(index);
    }

    public static void setFunctionIndexes(SQLNode functionNode, List<Column> columnsLoaded, Collection<PlanTableNode> tables) throws SQLException {
        for (FieldNode node : functionNode.getClauseFields()) {
            if (node instanceof FunctionNode) {
                FieldValueUtils.setFunctionIndexes(node, columnsLoaded, tables);
                continue;
            }
            FieldValueUtils.setFieldIndex(node, columnsLoaded, tables);
        }
    }

    public static Object getValue(Context context, Object[] row, FieldNode field, List<Column> columnsLoaded) throws SQLException {
        Object ret = field instanceof ParameterNode ? ((ParameterNode)field).getValue(context.getParameters()) : (field instanceof FunctionNode ? ((FunctionNode)field).execute(context, row, columnsLoaded) : (field.getIndex() == -1 ? field.getName() : row[field.getIndex()]));
        return ret;
    }
}

