/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.parser.nodes;

import com.googlecode.paradox.parser.ScannerPosition;
import com.googlecode.paradox.parser.nodes.AbstractConditionalNode;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.parser.nodes.StatementNode;
import com.googlecode.paradox.parser.nodes.TableNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.sorting.OrderType;
import java.util.ArrayList;
import java.util.List;

public final class SelectNode
extends StatementNode {
    private final List<SQLNode> fields = new ArrayList<SQLNode>();
    private final List<FieldNode> groups = new ArrayList<FieldNode>();
    private final List<FieldNode> order = new ArrayList<FieldNode>();
    private final List<OrderType> orderTypes = new ArrayList<OrderType>();
    private final List<TableNode> tables = new ArrayList<TableNode>();
    private AbstractConditionalNode condition;
    private boolean distinct;
    private Integer limit;
    private Integer offset;

    public SelectNode(ScannerPosition position) {
        super("SELECT", position);
    }

    public void addField(SQLNode field) {
        this.fields.add(field);
    }

    public void addTable(TableNode table) {
        this.tables.add(table);
    }

    public AbstractConditionalNode getCondition() {
        return this.condition;
    }

    public void setCondition(AbstractConditionalNode condition) {
        this.condition = condition;
    }

    public List<FieldNode> getOrder() {
        return this.order;
    }

    public List<SQLNode> getFields() {
        return this.fields;
    }

    public List<TableNode> getTables() {
        return this.tables;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        builder.append(' ');
        this.buildFields(builder);
        this.buildFrom(builder);
        this.buildWhere(builder);
        this.buildGroupBy(builder);
        this.buildOrderBy(builder);
        return builder.toString();
    }

    private void buildFields(StringBuilder builder) {
        boolean first = true;
        for (SQLNode field : this.fields) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(field);
        }
    }

    private void buildFrom(StringBuilder builder) {
        if (!this.tables.isEmpty()) {
            builder.append(" FROM ");
            boolean first = true;
            for (TableNode table : this.tables) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(table);
            }
        }
    }

    private void buildGroupBy(StringBuilder builder) {
        if (!this.groups.isEmpty()) {
            builder.append(" GROUP BY ");
            boolean first = true;
            for (FieldNode group : this.groups) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(group);
            }
        }
    }

    private void buildOrderBy(StringBuilder builder) {
        if (!this.order.isEmpty()) {
            builder.append(" ORDER BY ");
            boolean first = true;
            for (FieldNode identifier : this.order) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(identifier);
            }
        }
    }

    private void buildWhere(StringBuilder builder) {
        if (this.condition != null) {
            builder.append(" WHERE ");
            builder.append(this.condition);
        }
    }

    public void addGroupBy(FieldNode fieldNode) {
        this.groups.add(fieldNode);
    }

    public void addOrderBy(FieldNode identifier, OrderType type) {
        this.order.add(identifier);
        this.orderTypes.add(type);
    }

    public List<FieldNode> getGroups() {
        return this.groups;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<OrderType> getOrderTypes() {
        return this.orderTypes;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }
}

