/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.parser;

public enum TokenType {
    AND,
    AS,
    ASC,
    ASTERISK("*"),
    BETWEEN,
    BY,
    CHARACTER(null),
    COMMA(","),
    DESC,
    DELETE,
    DISTINCT,
    EQUALS("="),
    ESCAPE,
    FALSE,
    FOR,
    FROM,
    GROUP,
    IDENTIFIER,
    IN,
    INNER,
    FULL,
    CROSS,
    INSERT,
    INTO,
    JOIN,
    LEFT,
    LESS("<"),
    LIKE,
    LIMIT,
    ILIKE,
    IS,
    L_PAREN("("),
    MINUS("-"),
    MORE(">"),
    NOT,
    NOT_EQUALS("<>"),
    NULL,
    NUMERIC(null),
    OFFSET,
    ON,
    OR,
    ORDER,
    OUTER,
    PERIOD("."),
    PLUS("+"),
    QUESTION_MARK("?"),
    RIGHT,
    R_PAREN(")"),
    SELECT,
    SEMI(";"),
    TRUE,
    UPDATE,
    USING,
    WHERE;

    private static final TokenType[] CONDITIONAL_BREAKS;
    private static final TokenType[] OPERATORS;
    private static final TokenType[] SELECT_BREAKS;
    private final String value;

    private TokenType() {
        this.value = this.name();
    }

    private TokenType(String value) {
        this.value = value;
    }

    public static TokenType get(String value) {
        for (TokenType token : TokenType.values()) {
            if (!value.equalsIgnoreCase(token.value)) continue;
            return token;
        }
        return null;
    }

    public static boolean isConditionalBreak(TokenType tokenType) {
        for (TokenType token : CONDITIONAL_BREAKS) {
            if (token != tokenType) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelectBreak(TokenType tokenType) {
        for (TokenType token : SELECT_BREAKS) {
            if (token != tokenType) continue;
            return true;
        }
        return false;
    }

    public static boolean isOperator(TokenType tokenType) {
        for (TokenType token : OPERATORS) {
            if (token != tokenType) continue;
            return true;
        }
        return false;
    }

    static {
        CONDITIONAL_BREAKS = new TokenType[]{ORDER, R_PAREN, LEFT, RIGHT, OUTER, INNER, JOIN, FULL, CROSS};
        OPERATORS = new TokenType[]{AND, OR, NOT};
        SELECT_BREAKS = new TokenType[]{WHERE, ORDER, GROUP, LIMIT, OFFSET};
    }
}

